/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.curvecalibration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.finmath.smartcontract.model.MarketDataList;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationParser;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProvider;
import net.finmath.smartcontract.valuation.marketdata.data.MarketDataPoint;

public class CalibrationDataset {
    private static final String FIXING = "Fixing";
    LocalDateTime scenarioDate;
    Set<CalibrationDataItem> calibrationDataItems;
    Set<CalibrationDataItem> fixingDataItems;

    public CalibrationDataset(Set<CalibrationDataItem> curveDataPointSet, LocalDateTime scenarioDate) {
        this.scenarioDate = scenarioDate;
        this.fixingDataItems = curveDataPointSet.stream().filter(dataItem -> dataItem.getProductName().equals(FIXING)).sorted(Comparator.comparing(CalibrationDataItem::getDate)).collect(Collectors.toCollection(LinkedHashSet::new));
        this.calibrationDataItems = curveDataPointSet.stream().filter(dataItem -> !dataItem.getProductName().equals(FIXING)).sorted(Comparator.comparing(CalibrationDataItem::getDaysToMaturity)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public CalibrationDataset getScaled(double scaleFactor) {
        Set scaledSet = this.calibrationDataItems.stream().map(point -> point.getClonedScaled(scaleFactor)).collect(Collectors.toCollection(LinkedHashSet::new));
        return new CalibrationDataset(scaledSet, this.scenarioDate);
    }

    public Set<CalibrationDataItem> getFixingDataItems() {
        return this.fixingDataItems;
    }

    public CalibrationDataset getClonedFixingsAdded(Set<CalibrationDataItem> newFixingDataItems) {
        LinkedHashSet<CalibrationDataItem> clone = new LinkedHashSet<CalibrationDataItem>();
        clone.addAll(this.calibrationDataItems);
        clone.addAll(this.fixingDataItems);
        newFixingDataItems.stream().forEach(newFixing -> {
            if (newFixing.getProductName().equals(FIXING) && !this.fixingDataItems.stream().filter(fixing -> fixing.getCurveName().equals(newFixing.getCurveName()) && fixing.getDate().equals(newFixing.getDate())).findAny().isPresent()) {
                clone.add((CalibrationDataItem)newFixing);
            }
        });
        return new CalibrationDataset(clone, this.scenarioDate);
    }

    public MarketDataList toMarketDataList() {
        List<MarketDataPoint> marketDataPointList = this.calibrationDataItems.stream().map(item -> new MarketDataPoint(item.getSpec().getKey(), item.getQuote(), item.getDateTime())).toList();
        List<MarketDataPoint> fixings = this.fixingDataItems.stream().map(item -> new MarketDataPoint(item.getSpec().getKey(), item.getQuote(), item.getDateTime())).toList();
        MarketDataList marketDataList = new MarketDataList();
        marketDataPointList.forEach(marketDataList::add);
        fixings.forEach(marketDataList::add);
        return marketDataList;
    }

    public String serializeToJson() {
        ObjectMapper mapper = new ObjectMapper();
        String date = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
        String quoteKey = "Quotes";
        String fixingKey = "Fixings";
        LinkedHashMap nestedMap = new LinkedHashMap();
        nestedMap.put(date, new LinkedHashMap());
        ((Map)nestedMap.get(date)).put(quoteKey, new LinkedHashMap());
        for (CalibrationDataItem item : this.calibrationDataItems) {
            if (!((Map)((Map)nestedMap.get(date)).get(quoteKey)).containsKey(item.getSpec().getCurveName())) {
                ((Map)((Map)nestedMap.get(date)).get(quoteKey)).put(item.getSpec().getCurveName(), new LinkedHashMap());
            }
            if (!((Map)((Map)((Map)nestedMap.get(date)).get(quoteKey)).get(item.getSpec().getCurveName())).containsKey(item.getSpec().getProductName())) {
                ((Map)((Map)((Map)nestedMap.get(date)).get(quoteKey)).get(item.getSpec().getCurveName())).put(item.getSpec().getProductName(), new LinkedHashMap());
            }
            ((Map)((Map)((Map)((Map)nestedMap.get(date)).get(quoteKey)).get(item.getSpec().getCurveName())).get(item.getSpec().getProductName())).put(item.getSpec().getMaturity(), item.getQuote());
        }
        ((Map)nestedMap.get(date)).put(fixingKey, new LinkedHashMap());
        for (CalibrationDataItem item : this.fixingDataItems) {
            if (!((Map)((Map)nestedMap.get(date)).get(fixingKey)).containsKey(item.getSpec().getCurveName())) {
                ((Map)((Map)nestedMap.get(date)).get(fixingKey)).put(item.getSpec().getCurveName(), new LinkedHashMap());
            }
            if (!((Map)((Map)((Map)nestedMap.get(date)).get(fixingKey)).get(item.getSpec().getCurveName())).containsKey(item.getSpec().getProductName())) {
                ((Map)((Map)((Map)nestedMap.get(date)).get(fixingKey)).get(item.getSpec().getCurveName())).put(item.getSpec().getProductName(), new LinkedHashMap());
            }
            ((Map)((Map)((Map)((Map)nestedMap.get(date)).get(fixingKey)).get(item.getSpec().getCurveName())).get(item.getSpec().getProductName())).put(item.getDateString(), item.getQuote());
        }
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(nestedMap);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Stream<CalibrationSpecProvider> getDataAsCalibrationDataPointStream(CalibrationParser parser) {
        return parser.parse(this.calibrationDataItems.stream().filter(dataItem -> !dataItem.getProductName().equals(FIXING) && !dataItem.getProductName().equals("Deposit") && !dataItem.getSpec().getMaturity().equals("0D")));
    }

    public Set<CalibrationDataItem> getDataPoints() {
        HashSet<CalibrationDataItem> allItems = new HashSet<CalibrationDataItem>();
        allItems.addAll(this.calibrationDataItems);
        allItems.addAll(this.fixingDataItems);
        return allItems;
    }

    public LocalDateTime getDate() {
        return this.scenarioDate;
    }
}

