/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.curvecalibration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.finmath.smartcontract.model.ExceptionId;
import net.finmath.smartcontract.model.MarketDataList;
import net.finmath.smartcontract.model.SDCException;
import net.finmath.smartcontract.product.xml.SDCXMLParser;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataset;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationParser;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProvider;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProviderDeposit;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProviderFRA;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProviderOis;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProviderSwap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalibrationParserDataItems
implements CalibrationParser {
    private static final Logger logger = LoggerFactory.getLogger(CalibrationParserDataItems.class);

    @Override
    public Stream<CalibrationSpecProvider> parse(Stream<CalibrationDataItem> datapoints) {
        return datapoints.map(this::parseDatapointIfPresent).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<CalibrationSpecProvider> parseDatapointIfPresent(CalibrationDataItem datapoint) {
        switch (datapoint.getCurveName()) {
            case "ESTR": 
            case "EONIA": {
                if (datapoint.getProductName().equals("Swap-Rate")) {
                    return Optional.of(new CalibrationSpecProviderOis(datapoint.getMaturity(), "annual", datapoint.getQuote()));
                }
                return Optional.empty();
            }
            case "Euribor6M": {
                if (datapoint.getProductName().equalsIgnoreCase("Swap-Rate")) {
                    return Optional.of(new CalibrationSpecProviderSwap("6M", "semiannual", datapoint.getMaturity(), datapoint.getQuote()));
                }
                if (datapoint.getProductName().equalsIgnoreCase("Forward-Rate-Agreement")) {
                    return Optional.of(new CalibrationSpecProviderFRA("6M", datapoint.getMaturity(), datapoint.getQuote()));
                }
                if (datapoint.getProductName().equalsIgnoreCase("Deposit") || datapoint.getProductName().equalsIgnoreCase("Deposit-Rate")) {
                    return Optional.of(new CalibrationSpecProviderDeposit("6M", datapoint.getMaturity(), datapoint.getQuote()));
                }
                return Optional.empty();
            }
            case "Euribor1M": {
                return Optional.of(new CalibrationSpecProviderSwap("1M", "monthly", datapoint.getMaturity(), datapoint.getQuote()));
            }
            case "Euribor3M": {
                return Optional.of(new CalibrationSpecProviderSwap("3M", "quarterly", datapoint.getMaturity(), datapoint.getQuote()));
            }
        }
        logger.warn("Ignored data point.");
        return Optional.empty();
    }

    public static List<CalibrationDataset> getScenariosFromJsonFile(String fileName) throws IOException {
        String content;
        try (InputStream inputStream = CalibrationParserDataItems.class.getResourceAsStream(fileName);){
            content = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("Please provide the market data file: {}.", (Object)fileName, (Object)e);
            throw e;
        }
        return CalibrationParserDataItems.getScenariosFromJsonString(content);
    }

    public static CalibrationDataset getCalibrationDataSetFromXML(String xmlString, List<CalibrationDataItem.Spec> dataSpecs) {
        MarketDataList marketDataList = SDCXMLParser.unmarshalXml(xmlString, MarketDataList.class);
        LinkedHashSet<CalibrationDataItem> calibrationDataItems = new LinkedHashSet<CalibrationDataItem>();
        dataSpecs.forEach(spec -> {
            Set calibrationDataItemSet = marketDataList.getPoints().stream().filter(marketDataPoint -> marketDataPoint.getId().equals(spec.getKey())).map(point -> new CalibrationDataItem((CalibrationDataItem.Spec)spec, point.getValue(), point.getTimeStamp())).collect(Collectors.toSet());
            calibrationDataItems.addAll(calibrationDataItemSet);
        });
        if (calibrationDataItems.isEmpty()) {
            throw new SDCException(ExceptionId.SDC_CALIBRATION_DATA_EMPTY, "No calibration items detected.");
        }
        return new CalibrationDataset(calibrationDataItems, marketDataList.getRequestTimeStamp());
    }

    public static List<CalibrationDataset> getScenariosFromCSVFile(String fileName) throws IOException {
        throw new IOException("to be implemented");
    }

    public static final List<CalibrationDataset> getScenariosFromJsonString(String content) {
        Map timeSeriesDatamap;
        try {
            ObjectMapper mapper = new ObjectMapper();
            timeSeriesDatamap = (Map)mapper.readValue(content, new LinkedHashMap().getClass());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Bad format.", e);
        }
        return timeSeriesDatamap.entrySet().stream().map(scenarioData -> {
            String timeStampStr = (String)scenarioData.getKey();
            LocalDateTime dateTime = CalibrationParserDataItems.parseTimestampString(timeStampStr);
            Set quotes = ((Map)((Map)scenarioData.getValue()).get("Quotes")).entrySet().stream().map(entry -> CalibrationParserDataItems.getCalibrationDataItemSet((String)entry.getKey(), (Map)entry.getValue(), dateTime)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            CalibrationDataset scenario = new CalibrationDataset(quotes, dateTime);
            if (((Map)scenarioData.getValue()).containsKey("Fixings")) {
                Set fixings = ((Map)((Map)scenarioData.getValue()).get("Fixings")).entrySet().stream().map(entry -> CalibrationParserDataItems.getFixingDataItemSet((String)entry.getKey(), (Map)entry.getValue(), dateTime)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
                scenario = scenario.getClonedFixingsAdded(fixings);
            }
            return scenario;
        }).sorted((scenario1, scenario2) -> scenario1.getDate().compareTo(scenario2.getDate())).toList();
    }

    private static LocalDateTime parseTimestampString(String timeStampString) {
        LocalDateTime localDateTime;
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
        try {
            localDateTime = LocalDateTime.parse(timeStampString, dateTimeFormatter);
        }
        catch (Exception e) {
            LocalDate date = LocalDate.parse(timeStampString, dateFormatter);
            localDateTime = date.atTime(17, 0);
        }
        return localDateTime;
    }

    private static Set<CalibrationDataItem> getCalibrationDataItemSet(String curveKey, Map<String, Map<String, Double>> typeCurveMap, LocalDateTime timestamp) {
        return typeCurveMap.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream().map(curvePointEntry -> {
            String specKey = curveKey + "_" + (String)entry.getKey() + "_" + (String)curvePointEntry.getKey();
            CalibrationDataItem.Spec spec = new CalibrationDataItem.Spec(specKey, curveKey, (String)entry.getKey(), (String)curvePointEntry.getKey());
            return new CalibrationDataItem(spec, (Double)curvePointEntry.getValue(), timestamp);
        })).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Set<CalibrationDataItem> getFixingDataItemSet(String curveKey, Map<String, Map<String, Double>> typeCurveMap, LocalDateTime timestamp) {
        return typeCurveMap.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream().map(curvePointEntry -> {
            LocalDate fixingDate = LocalDate.parse((CharSequence)curvePointEntry.getKey(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String specKey = curveKey + "_" + (String)entry.getKey() + "_" + (String)curvePointEntry.getKey();
            CalibrationDataItem.Spec spec = new CalibrationDataItem.Spec(specKey, curveKey, (String)entry.getKey(), "1D");
            return new CalibrationDataItem(spec, (Double)curvePointEntry.getValue(), fixingDate.atStartOfDay());
        })).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

