/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.curvecalibration;

import java.time.LocalDate;
import net.finmath.marketdata.calibration.CalibratedCurves;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationContext;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProvider;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;

public class CalibrationSpecProviderDeposit
implements CalibrationSpecProvider {
    private final String tenorLabel;
    private final String maturityLabel;
    private final double depositRate;

    public CalibrationSpecProviderDeposit(String tenorLabel, String maturityLabel, double depositRate) {
        this.tenorLabel = tenorLabel;
        this.maturityLabel = maturityLabel;
        this.depositRate = depositRate;
    }

    @Override
    public CalibratedCurves.CalibrationSpec getCalibrationSpec(CalibrationContext ctx) {
        Schedule scheduleInterfaceRec = ScheduleGenerator.createScheduleFromConventions((LocalDate)ctx.getReferenceDate(), (int)2, (String)"0D", (String)this.maturityLabel, (String)"tenor", (String)"ACT/360", (String)"first", (String)"modfollow", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), (int)0, (int)0);
        double calibrationTime = scheduleInterfaceRec.getFixing(scheduleInterfaceRec.getNumberOfPeriods() - 1);
        String curveName = String.format("forward-EUR-%1$s", this.tenorLabel);
        return new CalibratedCurves.CalibrationSpec("EUR-" + this.tenorLabel + this.maturityLabel, "Deposit", scheduleInterfaceRec, curveName, this.depositRate, "discount-EUR-OIS", null, "", 0.0, "discount-EUR-OIS", curveName, calibrationTime);
    }
}

