/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.curvecalibration;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.finmath.marketdata.calibration.CalibratedCurves;
import net.finmath.marketdata.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveInterpolation;
import net.finmath.marketdata.model.curves.DiscountCurveInterpolation;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterpolation;
import net.finmath.marketdata.model.curves.ForwardCurveWithFixings;
import net.finmath.optimizer.SolverException;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationContext;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationResult;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProvider;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import org.apache.commons.lang3.ArrayUtils;

public class Calibrator {
    public static final String DISCOUNT_EUR_OIS = "discount-EUR-OIS";
    private final List<CalibrationDataItem> fixings;
    private final LocalDate referenceDate;
    private CalibratedCurves calibratedCurves;

    public Calibrator(List<CalibrationDataItem> fixings, CalibrationContext ctx) {
        this.fixings = fixings;
        this.referenceDate = ctx.getReferenceDate();
    }

    protected CalibratedCurves getCalibratedCurves() {
        return this.calibratedCurves;
    }

    public Optional<CalibrationResult> calibrateModel(Stream<CalibrationSpecProvider> providers, CalibrationContext ctx) throws CloneNotSupportedException {
        AnalyticModelFromCurvesAndVols model = new AnalyticModelFromCurvesAndVols(this.getCalibrationCurves(ctx));
        CalibratedCurves.CalibrationSpec[] specs = (CalibratedCurves.CalibrationSpec[])providers.map(c -> c.getCalibrationSpec(ctx)).toArray(CalibratedCurves.CalibrationSpec[]::new);
        try {
            this.calibratedCurves = new CalibratedCurves(specs, model, ctx.getAccuracy());
            return Optional.of(new CalibrationResult(this.calibratedCurves, specs));
        }
        catch (SolverException e) {
            return Optional.empty();
        }
    }

    private Curve[] getCalibrationCurves(CalibrationContext ctx) {
        return new Curve[]{this.getOisDiscountCurve(ctx), this.getOisForwardCurve(ctx), this.get1MForwardCurve(ctx), this.get3MForwardCurve(ctx), this.get6MForwardCurve(ctx)};
    }

    private DiscountCurveInterpolation getOisDiscountCurve(CalibrationContext ctx) {
        ArrayList<Double> fixingValuesList = new ArrayList<Double>();
        ArrayList<Double> fixingTimesList = new ArrayList<Double>();
        ArrayList<Double> dfList = new ArrayList<Double>();
        ArrayList<Double> dfTimesList = new ArrayList<Double>();
        this.fixings.stream().filter(x -> x.getCurveName().equals("ESTR")).sorted(Comparator.comparing(CalibrationDataItem::getDate).reversed()).forEach(x -> {
            double time = FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)this.referenceDate.atStartOfDay(), (LocalDateTime)x.dateTime);
            Double quote = x.getQuote();
            if (time < 0.0) {
                fixingTimesList.add(time);
                fixingValuesList.add(365.0 * Math.log(1.0 + quote / 360.0));
            }
        });
        fixingValuesList.add(0, 0.0);
        fixingTimesList.add(0, FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)this.referenceDate.atStartOfDay(), (LocalDateTime)this.referenceDate.atTime(17, 0, 0)));
        fixingValuesList.add(1, 0.0);
        fixingTimesList.add(1, 0.0);
        dfTimesList.add(FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)this.referenceDate.atStartOfDay(), (LocalDateTime)this.referenceDate.atTime(17, 0, 0)));
        dfList.add(1.0);
        dfTimesList.add(0.0);
        dfList.add(1.0);
        double dfLast = 1.0;
        for (int i = 2; i < fixingTimesList.size(); ++i) {
            dfList.add(dfLast * Math.exp((Double)fixingValuesList.get(i) * ((Double)fixingTimesList.get(i - 1) - (Double)fixingTimesList.get(i))));
            dfLast = (Double)dfList.get(i);
            dfTimesList.add((Double)fixingTimesList.get(i));
        }
        boolean[] isParameters = ArrayUtils.toPrimitive((Boolean[])((Boolean[])IntStream.range(0, dfTimesList.size()).boxed().map(x -> false).toList().toArray(Boolean[]::new)));
        double[] dfTimes = dfTimesList.stream().mapToDouble(Double::doubleValue).toArray();
        double[] dfValues = dfList.stream().mapToDouble(Double::doubleValue).toArray();
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors((String)DISCOUNT_EUR_OIS, (LocalDate)ctx.getReferenceDate(), (double[])dfTimes, (double[])dfValues, (boolean[])isParameters, (CurveInterpolation.InterpolationMethod)CurveInterpolation.InterpolationMethod.LINEAR, (CurveInterpolation.ExtrapolationMethod)CurveInterpolation.ExtrapolationMethod.CONSTANT, (CurveInterpolation.InterpolationEntity)CurveInterpolation.InterpolationEntity.LOG_OF_VALUE);
    }

    private ForwardCurve getOisForwardCurve(CalibrationContext ctx) {
        return new ForwardCurveFromDiscountCurve("forward-EUR-OIS", DISCOUNT_EUR_OIS, DISCOUNT_EUR_OIS, ctx.getReferenceDate(), "1D", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendar.DateRollConvention.FOLLOWING, 1.0138888888888888, 0.0);
    }

    private ForwardCurve get3MForwardCurve(CalibrationContext ctx) {
        double[] fixingTimes = this.fixings.stream().filter(x -> x.getCurveName().equals("Euribor3M")).map(x -> x.dateTime).map(x -> FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)this.referenceDate.atStartOfDay(), (LocalDateTime)x)).mapToDouble(Double::doubleValue).sorted().toArray();
        if (fixingTimes.length == 0) {
            return new ForwardCurveInterpolation("forward-EUR-3M", ctx.getReferenceDate(), "3M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendar.DateRollConvention.FOLLOWING, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
        }
        double[] fixingValues = this.fixings.stream().filter(x -> x.getCurveName().equals("Euribor3M")).sorted(Comparator.comparing(CalibrationDataItem::getDate)).map(CalibrationDataItem::getQuote).mapToDouble(Double::doubleValue).toArray();
        ForwardCurveInterpolation fixedPart = ForwardCurveInterpolation.createForwardCurveFromForwards((String)"fixed-EUR-3M", (LocalDate)ctx.getReferenceDate(), (String)"3M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), (BusinessdayCalendar.DateRollConvention)BusinessdayCalendar.DateRollConvention.FOLLOWING, (CurveInterpolation.InterpolationMethod)CurveInterpolation.InterpolationMethod.LINEAR, (CurveInterpolation.ExtrapolationMethod)CurveInterpolation.ExtrapolationMethod.CONSTANT, (CurveInterpolation.InterpolationEntity)CurveInterpolation.InterpolationEntity.VALUE, (ForwardCurveInterpolation.InterpolationEntityForward)ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, (String)DISCOUNT_EUR_OIS, null, (double[])fixingTimes, (double[])fixingValues);
        ForwardCurveInterpolation forwardPart = new ForwardCurveInterpolation("forward-EUR-3M", ctx.getReferenceDate(), "3M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendar.DateRollConvention.FOLLOWING, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
        return new ForwardCurveWithFixings((ForwardCurve)forwardPart, (ForwardCurve)fixedPart, Arrays.stream(fixingTimes).min().orElseThrow() - 0.0027397260273972603, Arrays.stream(fixingTimes).max().orElseThrow() + 0.0027397260273972603);
    }

    private ForwardCurve get6MForwardCurve(CalibrationContext ctx) {
        double[] fixingTimes = this.fixings.stream().filter(x -> x.getCurveName().equals("Euribor6M")).map(x -> x.dateTime).map(x -> FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)this.referenceDate.atStartOfDay(), (LocalDateTime)x)).mapToDouble(Double::doubleValue).sorted().toArray();
        if (fixingTimes.length == 0) {
            return new ForwardCurveInterpolation("forward-EUR-6M", ctx.getReferenceDate(), "6M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendar.DateRollConvention.FOLLOWING, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
        }
        double[] fixingValues = this.fixings.stream().filter(x -> x.getCurveName().equals("Euribor6M")).sorted(Comparator.comparing(CalibrationDataItem::getDate)).map(CalibrationDataItem::getQuote).mapToDouble(Double::doubleValue).toArray();
        ForwardCurveInterpolation fixedPart = ForwardCurveInterpolation.createForwardCurveFromForwards((String)"fixed-EUR-6M", (LocalDate)ctx.getReferenceDate(), (String)"6M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), (BusinessdayCalendar.DateRollConvention)BusinessdayCalendar.DateRollConvention.FOLLOWING, (CurveInterpolation.InterpolationMethod)CurveInterpolation.InterpolationMethod.LINEAR, (CurveInterpolation.ExtrapolationMethod)CurveInterpolation.ExtrapolationMethod.CONSTANT, (CurveInterpolation.InterpolationEntity)CurveInterpolation.InterpolationEntity.VALUE, (ForwardCurveInterpolation.InterpolationEntityForward)ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, (String)DISCOUNT_EUR_OIS, null, (double[])fixingTimes, (double[])fixingValues);
        ForwardCurveInterpolation forwardPart = new ForwardCurveInterpolation("forward-EUR-6M", ctx.getReferenceDate(), "6M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendar.DateRollConvention.FOLLOWING, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
        return new ForwardCurveWithFixings((ForwardCurve)forwardPart, (ForwardCurve)fixedPart, Arrays.stream(fixingTimes).min().orElseThrow() - 0.0027397260273972603, Arrays.stream(fixingTimes).max().orElseThrow() + 0.0027397260273972603);
    }

    private ForwardCurve get1MForwardCurve(CalibrationContext ctx) {
        double[] fixingTimes = this.fixings.stream().filter(x -> x.getCurveName().equals("Euribor1M")).map(x -> x.dateTime).map(x -> FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)this.referenceDate.atStartOfDay(), (LocalDateTime)x)).mapToDouble(Double::doubleValue).sorted().toArray();
        if (fixingTimes.length == 0) {
            return new ForwardCurveInterpolation("forward-EUR-1M", ctx.getReferenceDate(), "1M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendar.DateRollConvention.FOLLOWING, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
        }
        double[] fixingValues = this.fixings.stream().filter(x -> x.getCurveName().equals("Euribor1M")).sorted(Comparator.comparing(CalibrationDataItem::getDate)).map(CalibrationDataItem::getQuote).mapToDouble(Double::doubleValue).toArray();
        ForwardCurveInterpolation fixedPart = ForwardCurveInterpolation.createForwardCurveFromForwards((String)"fixed-EUR-1M", (LocalDate)ctx.getReferenceDate(), (String)"1M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), (BusinessdayCalendar.DateRollConvention)BusinessdayCalendar.DateRollConvention.FOLLOWING, (CurveInterpolation.InterpolationMethod)CurveInterpolation.InterpolationMethod.LINEAR, (CurveInterpolation.ExtrapolationMethod)CurveInterpolation.ExtrapolationMethod.CONSTANT, (CurveInterpolation.InterpolationEntity)CurveInterpolation.InterpolationEntity.VALUE, (ForwardCurveInterpolation.InterpolationEntityForward)ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, (String)DISCOUNT_EUR_OIS, null, (double[])fixingTimes, (double[])fixingValues);
        ForwardCurveInterpolation forwardPart = new ForwardCurveInterpolation("forward-EUR-1M", ctx.getReferenceDate(), "1M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendar.DateRollConvention.FOLLOWING, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
        return new ForwardCurveWithFixings((ForwardCurve)forwardPart, (ForwardCurve)fixedPart, Arrays.stream(fixingTimes).min().orElseThrow() - 0.0027397260273972603, Arrays.stream(fixingTimes).max().orElseThrow() + 0.0027397260273972603);
    }
}

