/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.database;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import net.finmath.smartcontract.valuation.service.utils.ResourceGovernor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!test"})
public class DatabaseConnector {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseConnector.class);
    private Connection connection;
    private final ResourceGovernor resourceGovernor;

    public DatabaseConnector(ResourceGovernor resourceGovernor) {
        this.resourceGovernor = resourceGovernor;
    }

    @PostConstruct
    public void init() {
        try {
            Properties databaseConnectionProperties = new Properties();
            databaseConnectionProperties.load(new StringReader(this.resourceGovernor.getDatabasePropertiesAsResourceInReadMode().getContentAsString(StandardCharsets.UTF_8)));
            this.connection = DriverManager.getConnection(databaseConnectionProperties.getProperty("URL"), databaseConnectionProperties.getProperty("USERNAME"), databaseConnectionProperties.getProperty("PASSWORD"));
            logger.info("Connected to the PostgreSQL server successfully.");
        }
        catch (IOException | SQLException e) {
            logger.warn("Could not establish a connection to a database. Running without.");
        }
    }

    public void fetchFromDatabase(List<String> fixingSymbols, String username) throws SQLException, IOException {
        block12: {
            try (Statement fetchStatement = this.connection.createStatement();){
                if (!fetchStatement.execute("SELECT json_build_object('requestTimestamp',to_json((now() at time zone 'utc')::timestamptz(0)),'values',json_agg(t1)) FROM (\nSELECT \t\"dataTimestamp_\"::timestamptz(0) as \"dataTimestamp\",\n\"symbolId_\" as \"symbol\",\n\"value_\" as \"value\"\nFROM (SELECT * FROM (SELECT T10.\"symbolId_\", T10.\"dataTimestamp_\", T10.\"value_\" FROM\npublic.\"MarketDataPoints\" AS T10, public.\"MarketDataPoints\" AS T20\nWHERE T10.\"symbolId_\" = T20.\"symbolId_\"\nGROUP BY  T20.\"symbolId_\",  T10.\"dataTimestamp_\", T10.\"symbolId_\"\nHAVING T10.\"dataTimestamp_\" = MAX(t20.\"dataTimestamp_\")\nORDER BY T10.\"symbolId_\") AS T30\nUNION SELECT \"symbolId_\", \"dataTimestamp_\", \"value_\" FROM public.\"MarketDataPoints\"\nWHERE \"symbolId_\" IN (%s)\nORDER BY \"symbolId_\") AS T5) AS T1;\n".formatted(fixingSymbols.stream().collect(Collectors.joining("','", "'", "'"))).replaceFirst(".$", "")) || !fetchStatement.getResultSet().next()) break block12;
                String rawOutput = fetchStatement.getResultSet().getString(1);
                logger.info("Writing dataset...");
                logger.info(rawOutput);
                try (OutputStream outputStream = this.resourceGovernor.getActiveDatasetAsResourceInWriteMode(username).getOutputStream();){
                    outputStream.write(rawOutput.getBytes());
                    logger.info("...done.");
                }
            }
        }
    }

    public void updateDatabase() throws SQLException, IOException {
        try (Statement importTableCreationStatement = this.connection.createStatement();
             Statement importStatement = this.connection.createStatement();
             Statement clearAfterUpdateStatement = this.connection.createStatement();){
            String importfileLocation = this.resourceGovernor.getImportCandidateAsResourceInReadMode().getFile().getAbsolutePath();
            String sql = "CREATE UNLOGGED TABLE IF NOT EXISTS import_helper (import_helper text);\nDELETE FROM import_helper;\nCOPY import_helper FROM '%s';\n".formatted(importfileLocation);
            importTableCreationStatement.execute(sql);
            importStatement.execute("INSERT INTO public.\"MarketDataPoints\"\n  SELECT \t(dataPoints_ ->> 'dataTimestamp')::timestamp without time zone AS dataTimestamp_,\n\t(dataPoints_ ->> 'symbol')::varchar AS symbolId_,\n\t((dataPoints_ ->> 'value')::double precision)/100 AS value_,\n\t1 AS owner_,\n\t'remote' AS source_ FROM (\nSELECT json_array_elements(values_) AS dataPoints_ FROM (\n\tSELECT string_agg(import_helper, '')::json -> 'values' AS values_ FROM import_helper\n\t) AS t1\n) AS t2\n  ON CONFLICT ON CONSTRAINT \"MarketDataPoints_pkey\" DO NOTHING;\n");
            clearAfterUpdateStatement.execute("DROP TABLE IF EXISTS import_helper;");
        }
    }
}

