/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.generators;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketListener;
import io.reactivex.rxjava3.functions.Consumer;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.finmath.smartcontract.model.MarketDataList;
import net.finmath.smartcontract.product.SmartDerivativeContractDescriptor;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.generators.MarketDataGeneratorWebsocket;
import net.finmath.smartcontract.valuation.marketdata.generators.WebSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketDataGeneratorLauncher {
    private static final Logger logger = LoggerFactory.getLogger(MarketDataGeneratorLauncher.class);

    private MarketDataGeneratorLauncher() {
    }

    public static MarketDataList instantiateMarketDataGeneratorWebsocket(Properties connectionProperties, SmartDerivativeContractDescriptor sdc) {
        AtomicReference<MarketDataList> marketDataList = new AtomicReference<MarketDataList>(new MarketDataList());
        AtomicBoolean finished = new AtomicBoolean(false);
        logger.info("launching MarketDataGeneratorWebsocket");
        try {
            List<CalibrationDataItem.Spec> mdItemList = sdc.getMarketdataItemList();
            WebSocketConnector connector = new WebSocketConnector(connectionProperties);
            WebSocket socket = connector.getWebSocket();
            MarketDataGeneratorWebsocket emitter = new MarketDataGeneratorWebsocket(connector.getAuthJson(), connector.getPosition(), mdItemList);
            socket.addListener((WebSocketListener)emitter);
            socket.connect();
            Consumer marketDataWriter = s -> {
                logger.info("websocket open: {}", (Object)socket.isOpen());
                marketDataList.set((MarketDataList)s);
                finished.set(true);
                emitter.closeStreamsAndLogoff(socket);
                socket.sendClose();
            };
            emitter.asObservable().take(1L).subscribe(marketDataWriter);
            while (!finished.get()) {
                logger.info("Waiting for Market Data List to finish retrieving");
                Thread.sleep(1000L);
            }
            return marketDataList.get();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

