/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.utils;

import net.finmath.smartcontract.model.MarketDataList;
import net.finmath.smartcontract.product.xml.Smartderivativecontract;
import net.finmath.smartcontract.valuation.marketdata.utils.MarketDataErrors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketDataCheck {
    private static final Logger logger = LoggerFactory.getLogger(MarketDataCheck.class);

    private MarketDataCheck() {
    }

    public static MarketDataErrors checkMarketData(MarketDataList marketDataList, Smartderivativecontract sdc) {
        int counter = 0;
        if (marketDataList.getPoints().equals(new MarketDataList().getPoints())) {
            logger.error("marketData: {}", (Object)marketDataList);
            logger.error("trade will be suspended, no settlement will be performed");
            MarketDataErrors errors = new MarketDataErrors(true);
            errors.setErrorMessage("error in marketData service - no data generated");
            errors.addMissingData("all, no data provided");
            return errors;
        }
        boolean hasAllIDs = true;
        MarketDataErrors errors = new MarketDataErrors(true);
        for (Smartderivativecontract.Settlement.Marketdata.Marketdataitems.Item spec : sdc.getSettlement().getMarketdata().getMarketdataitems().getItem()) {
            String id = spec.getSymbol().get(0);
            boolean present = marketDataList.getPoints().stream().anyMatch(marketDataPoint -> marketDataPoint.getId().equals(id));
            if (present) continue;
            hasAllIDs = false;
            errors.addMissingData(id);
            logger.error("marketData invalid - marketDataPoint with id '{}' is missing", (Object)id);
            ++counter;
        }
        if (!hasAllIDs) {
            String reason = "error in marketData service - missing points in marketData";
            logger.error(reason);
            logger.error("'{}' marketDataItems are missing", (Object)counter);
            errors.setErrorMessage(reason);
            return errors;
        }
        logger.info("marketdata is fine");
        return new MarketDataErrors(false);
    }
}

