/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.oracle;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.stream.Collectors;
import net.finmath.smartcontract.valuation.oracle.ValuationOracle;

public class SmartDerivativeContractSettlementOracle {
    private final ValuationOracle derivativeValuationOracle;

    public SmartDerivativeContractSettlementOracle(ValuationOracle derivativeValuationOracle) {
        this.derivativeValuationOracle = derivativeValuationOracle;
    }

    public Map<String, BigDecimal> getMargin(LocalDateTime marginPeriodStart, LocalDateTime marginPeriodEnd) {
        Map<String, BigDecimal> valueDerivativeCurrent = this.derivativeValuationOracle.getValues(marginPeriodEnd, marginPeriodEnd);
        Map<String, BigDecimal> valueDerivativePrevious = this.derivativeValuationOracle.getValues(marginPeriodEnd, marginPeriodStart);
        Map<String, BigDecimal> margin = valueDerivativeCurrent.keySet().stream().collect(Collectors.toMap(key -> key, key -> ((BigDecimal)valueDerivativeCurrent.get(key)).subtract((BigDecimal)valueDerivativePrevious.get(key))));
        return margin;
    }
}

