/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.oracle;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import net.finmath.smartcontract.valuation.oracle.StochasticValuationOracle;
import net.finmath.smartcontract.valuation.oracle.ValuationOracle;
import org.javamoney.moneta.Money;

public class ValuationOracleSamplePath
implements ValuationOracle {
    private final CurrencyUnit currency = Monetary.getCurrency((String)"EUR", (String[])new String[0]);
    private final StochasticValuationOracle stochasticValuationOracle;
    private final int path;

    public ValuationOracleSamplePath(StochasticValuationOracle stochasticValuationOracle, int path) {
        this.stochasticValuationOracle = stochasticValuationOracle;
        this.path = path;
    }

    @Override
    public BigDecimal getValue(LocalDateTime evaluationTime, LocalDateTime marketDataTime) {
        return BigDecimal.valueOf(this.stochasticValuationOracle.getValue(evaluationTime, marketDataTime).get(this.path));
    }

    @Override
    public Map<String, BigDecimal> getValues(LocalDateTime evaluationTime, LocalDateTime marketDataTime) {
        return Map.of("value", this.getValue(evaluationTime, marketDataTime));
    }

    @Override
    public MonetaryAmount getAmount(LocalDateTime evaluationTime, LocalDateTime marketDataTime) {
        return Money.of((BigDecimal)this.getValue(evaluationTime, marketDataTime), (CurrencyUnit)this.currency);
    }
}

