/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.oracle.interestrates;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.smartcontract.model.ExceptionId;
import net.finmath.smartcontract.model.SDCException;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationContextImpl;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataset;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationParserDataItems;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationResult;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProvider;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.Calibrator;
import net.finmath.smartcontract.valuation.oracle.ValuationOracle;
import net.finmath.smartcontract.valuation.oracle.ValuationType;
import net.finmath.time.FloatingpointDate;
import org.javamoney.moneta.Money;

public class ValuationOraclePlainSwap
implements ValuationOracle {
    private final CurrencyUnit currency = Monetary.getCurrency((String)"EUR", (String[])new String[0]);
    private final List<CalibrationDataset> scenarioList;
    private final Map<String, AnalyticProduct> products;
    private final int scale;

    public ValuationOraclePlainSwap(Map<String, AnalyticProduct> products, List<CalibrationDataset> scenarioList, int scale) {
        this.products = products;
        this.scenarioList = scenarioList;
        this.scale = scale;
    }

    public ValuationOraclePlainSwap(Map<String, AnalyticProduct> products, List<CalibrationDataset> scenarioList) {
        this(products, scenarioList, 2);
    }

    @Override
    public MonetaryAmount getAmount(LocalDateTime evaluationTime, LocalDateTime marketDataTime) {
        return Money.of((BigDecimal)this.getValue(evaluationTime, marketDataTime), (CurrencyUnit)this.currency);
    }

    @Override
    public BigDecimal getValue(LocalDateTime evaluationDate, LocalDateTime marketDataTime) {
        return this.getValues(evaluationDate, marketDataTime).get("value");
    }

    @Override
    public Map<String, BigDecimal> getValues(LocalDateTime evaluationDate, LocalDateTime marketDataTime) {
        Optional<CalibrationDataset> optionalScenario = this.scenarioList.stream().filter(scenario -> scenario.getDate().equals(marketDataTime)).findAny();
        if (optionalScenario.isPresent()) {
            CalibrationDataset scenario2 = optionalScenario.get();
            LocalDate referenceDate = marketDataTime.toLocalDate();
            CalibrationParserDataItems parser = new CalibrationParserDataItems();
            try {
                Stream<CalibrationSpecProvider> allCalibrationItems = scenario2.getDataAsCalibrationDataPointStream(parser);
                List<CalibrationDataItem> fixings = scenario2.getDataPoints().stream().filter(cdi -> cdi.getSpec().getProductName().equals("Fixing") || cdi.getSpec().getProductName().equals("Deposit")).toList();
                Calibrator calibrator = new Calibrator(fixings, new CalibrationContextImpl(referenceDate, 1.0E-9));
                Optional<CalibrationResult> optionalCalibrationResult = calibrator.calibrateModel(allCalibrationItems, new CalibrationContextImpl(referenceDate, 1.0E-9));
                AnalyticModel calibratedModel = optionalCalibrationResult.orElseThrow().getCalibratedModel();
                double evaluationTime = FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)referenceDate.atStartOfDay(), (LocalDateTime)marketDataTime);
                Map<String, BigDecimal> values = this.products.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> BigDecimal.valueOf(((AnalyticProduct)e.getValue()).getValue(evaluationTime, calibratedModel)).setScale(this.scale, RoundingMode.HALF_UP)));
                return values;
            }
            catch (Exception e2) {
                throw new SDCException(ExceptionId.SDC_CALIBRATION_ERROR, e2.getMessage());
            }
        }
        return null;
    }

    public static enum ValuationTypeSwap implements ValuationType
    {
        VALUE,
        VALUE_RECEIVER_LEG,
        VALUE_PAYER_LEG;

    }
}

