/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.service.config;

import java.util.ArrayList;
import java.util.List;
import net.finmath.smartcontract.model.ExceptionId;
import net.finmath.smartcontract.model.SDCException;
import net.finmath.smartcontract.valuation.service.utils.ApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableWebSecurity
public class BasicAuthWebSecurityConfiguration {
    Logger logger = LoggerFactory.getLogger(BasicAuthWebSecurityConfiguration.class);
    @Value(value="${serviceUrl}")
    String serviceUrl;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.csrf(AbstractHttpConfigurer::disable).authorizeHttpRequests(authz -> {
            try {
                ((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.anyRequest()).authenticated().and()).httpBasic();
            }
            catch (Exception e) {
                throw new SDCException(ExceptionId.SDC_AUTH_ERROR, e.getMessage());
            }
        }).cors();
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public WebMvcConfigurer corsConfigurer() {
        this.logger.info("CORS filter has been loaded.");
        return new WebMvcConfigurer(){

            public void addCorsMappings(CorsRegistry registry) {
                registry.addMapping("/editor/**").allowedOrigins(new String[]{"http://localhost:4200", BasicAuthWebSecurityConfiguration.this.serviceUrl});
            }
        };
    }

    @Bean
    public InMemoryUserDetailsManager userDetailsService(ApplicationProperties applicationProperties) {
        return new InMemoryUserDetailsManager(this.buildUserDetailsList(applicationProperties));
    }

    private List<UserDetails> buildUserDetailsList(ApplicationProperties applicationProperties) {
        ArrayList<UserDetails> userDetailsList = new ArrayList<UserDetails>();
        applicationProperties.getUsers().forEach(sdcUser -> userDetailsList.add(User.withUsername((String)sdcUser.getUsername()).password("{noop}" + sdcUser.getPassword()).roles(new String[]{sdcUser.getRole()}).build()));
        return userDetailsList;
    }
}

