/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.service.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import java.io.InputStream;
import net.finmath.information.Library;
import net.finmath.smartcontract.api.InfoApi;
import net.finmath.smartcontract.model.ExceptionId;
import net.finmath.smartcontract.model.SDCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"http://localhost:4200", "${serviceUrl}"}, allowCredentials="true")
public class InfoController
implements InfoApi {
    private final Logger logger = LoggerFactory.getLogger(InfoController.class);
    private static final String GIT_ERROR = "Failed to get git info.";

    @Override
    public ResponseEntity<String> infoGit() {
        ResponseEntity responseEntity;
        block8: {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.add("Responded", "info git");
            InputStream propertiesInputStream = InfoController.class.getResourceAsStream("/git.properties");
            try {
                JavaPropsMapper mapper = new JavaPropsMapper();
                ObjectNode node = (ObjectNode)mapper.readValue(propertiesInputStream, ObjectNode.class);
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                String info = ow.writeValueAsString((Object)node);
                responseEntity = ResponseEntity.ok((Object)info);
                if (propertiesInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (propertiesInputStream != null) {
                        try {
                            propertiesInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error(GIT_ERROR);
                    this.logger.error(e.getMessage());
                    throw new SDCException(ExceptionId.SDC_GIT_ERROR, GIT_ERROR);
                }
            }
            propertiesInputStream.close();
        }
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> infoFinmath() {
        ResponseEntity responseEntity;
        block8: {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.add("Responded", "info finmath");
            InputStream propertiesInputStream = Library.class.getResourceAsStream("/finmath-lib.properties");
            try {
                JavaPropsMapper mapper = new JavaPropsMapper();
                ObjectNode node = (ObjectNode)mapper.readValue(propertiesInputStream, ObjectNode.class);
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                String info = ow.writeValueAsString((Object)node);
                responseEntity = ResponseEntity.ok((Object)info);
                if (propertiesInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (propertiesInputStream != null) {
                        try {
                            propertiesInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error(GIT_ERROR);
                    this.logger.error(e.getMessage());
                    throw new SDCException(ExceptionId.SDC_GIT_ERROR, GIT_ERROR);
                }
            }
            propertiesInputStream.close();
        }
        return responseEntity;
    }
}

