/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.service.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public abstract class SDCAbstractRounding {
    protected int scale;
    protected RoundingMode roundingMode;

    private BigDecimal round(double variable) {
        String s = Double.toString(variable);
        return new BigDecimal(s).setScale(this.scale, this.roundingMode);
    }

    public double roundDouble(double variable) {
        return this.round(variable).doubleValue();
    }

    private String getAsIntString(BigDecimal variable) {
        String margin = variable.toString();
        return margin.replace(".", "");
    }

    public String getRoundedValueAsIntegerString(double variable) {
        BigDecimal x = this.round(variable);
        return this.getAsIntString(x);
    }

    public double getDoubleFromIntegerString(String s) {
        String sf = null;
        if (s.length() == 1) {
            sf = "0.0" + s;
        } else if (s.length() == 2) {
            sf = "0." + s;
        } else {
            int i1 = s.length() - this.scale - 1;
            int i2 = s.length() - 1;
            sf = s.substring(0, i1 + 1) + "." + s.substring(i1 + 1, i2 + 1);
        }
        double x = Double.parseDouble(sf);
        return this.roundDouble(x);
    }
}

