/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.service.websocket.client;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.OnClose;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.finmath.smartcontract.model.ExceptionId;
import net.finmath.smartcontract.model.SDCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class WebSocketClientEndpoint
extends Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketClientEndpoint.class);
    private final PublishSubject<String> messageSubject = PublishSubject.create();
    private final URI endpointURI;
    private Session userSession;
    private final ClientEndpointConfig config;

    public WebSocketClientEndpoint(URI endpointURI, String user, String password) {
        this.endpointURI = endpointURI;
        this.config = ClientEndpointConfig.Builder.create().build();
        this.config.getUserProperties().put("Authorization", this.getBasicAuthHeader(user, password));
    }

    public Session getUserSession() {
        if (this.userSession == null) {
            this.initSession();
        }
        return this.userSession;
    }

    public Observable<String> asObservable() {
        if (this.userSession == null) {
            this.initSession();
        }
        return this.messageSubject;
    }

    private void initSession() {
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            container.setDefaultMaxBinaryMessageBufferSize(0x100000);
            this.userSession = container.connectToServer((Endpoint)this, this.config, this.endpointURI);
        }
        catch (Exception e) {
            throw new SDCException(ExceptionId.SDC_WEBSOCKET_CONNECTION_ERROR, e.getMessage());
        }
    }

    public void sendTextMessage(String message) throws IOException {
        if (this.userSession == null) {
            this.initSession();
        }
        this.userSession.getBasicRemote().sendText(message);
    }

    public void onOpen(Session session, EndpointConfig config) {
        logger.info("Opening websocket");
        session.addMessageHandler((MessageHandler)((MessageHandler.Whole)message -> logger.info("Received message: {}", message)));
    }

    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        logger.info("Closing websocket");
        this.messageSubject.onComplete();
        this.userSession = null;
    }

    private String getBasicAuthHeader(String username, String password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
        return "Basic " + new String(encodedAuth);
    }
}

