/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.service.websocket.handler;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketListener;
import io.reactivex.rxjava3.core.Observable;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.finmath.smartcontract.product.SmartDerivativeContractDescriptor;
import net.finmath.smartcontract.product.xml.SDCXMLParser;
import net.finmath.smartcontract.valuation.implementation.MarginCalculator;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.generators.MarketDataGeneratorWebsocket;
import net.finmath.smartcontract.valuation.marketdata.generators.WebSocketConnector;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class ValuationHandler
implements WebSocketHandler {
    private MarketDataGeneratorWebsocket marketDataWebSocketAdapter;

    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        String payload = null;
        if (!(message instanceof TextMessage)) {
            throw new IllegalStateException("Unexpected WebSocket message type: " + String.valueOf(message));
        }
        payload = (String)((TextMessage)message).getPayload();
        String sdcXML = payload;
        SmartDerivativeContractDescriptor sdc = SDCXMLParser.parse(sdcXML);
        List<CalibrationDataItem.Spec> mdItemList = sdc.getMarketdataItemList();
        String connectionPropertiesFile = "<your properties file>";
        Properties properties = new Properties();
        properties.load(new FileInputStream(connectionPropertiesFile));
        WebSocketConnector connector = new WebSocketConnector(properties);
        WebSocket socket = connector.getWebSocket();
        this.marketDataWebSocketAdapter = new MarketDataGeneratorWebsocket(connector.getAuthJson(), connector.getPosition(), mdItemList);
        socket.addListener((WebSocketListener)this.marketDataWebSocketAdapter);
        socket.connect();
        Observable observableValuation = this.marketDataWebSocketAdapter.asObservable().throttleLast(6L, TimeUnit.SECONDS).map(marketData -> {
            MarginCalculator calculator = new MarginCalculator();
            return calculator.getValue(marketData.serializeToJson(), sdcXML);
        });
        observableValuation.subscribe(s -> session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)s.toString())));
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
    }
}

