/*
 * Decompiled with CFR 0.152.
 */
package net.flexmojos.oss.nexus;

import java.io.IOException;
import java.util.Arrays;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.ConfigurationIdGenerator;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.events.AbstractEventInspector;
import org.sonatype.nexus.proxy.events.EventInspector;
import org.sonatype.nexus.proxy.events.NexusStartedEvent;
import org.sonatype.nexus.proxy.mapping.RepositoryPathMapping;
import org.sonatype.nexus.proxy.mapping.RequestRepositoryMapper;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.templates.TemplateProvider;
import org.sonatype.nexus.templates.repository.RepositoryTemplate;
import org.sonatype.plexus.appevents.Event;

@Component(role=EventInspector.class, hint="FlexmojosStartedEventInspector")
public class FlexmojosStartedEventInspector
extends AbstractEventInspector
implements EventInspector {
    @Requirement
    private RequestRepositoryMapper repositoryMapper;
    @Requirement(role=RepositoryRegistry.class)
    private RepositoryRegistry repositoryRegistry;
    @Requirement(role=TemplateProvider.class)
    private TemplateProvider templateProvider;
    @Requirement
    private NexusConfiguration nexusConfiguration;
    @Requirement
    private ConfigurationIdGenerator idGenerator;

    public boolean accepts(Event<?> evt) {
        return evt instanceof NexusStartedEvent;
    }

    public void inspect(Event<?> evt) {
        try {
            this.repositoryRegistry.getRepository("flexmojos");
        }
        catch (NoSuchRepositoryException e) {
            GroupRepository group;
            Repository repo = this.createFlexmojosRepository();
            if (repo != null && (group = this.setupPublicGroup(repo)) != null) {
                this.setupRouting(group, repo);
            }
            try {
                this.nexusConfiguration.saveConfiguration();
            }
            catch (IOException ex) {
                this.getLogger().error("Unable to save flexmojos repository setup", (Throwable)ex);
            }
        }
    }

    private GroupRepository setupPublicGroup(Repository repo) {
        GroupRepository publicGroup;
        try {
            publicGroup = (GroupRepository)this.repositoryRegistry.getRepositoryWithFacet("public", GroupRepository.class);
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().error("Public group not found", (Throwable)e);
            return null;
        }
        try {
            publicGroup.addMemberRepositoryId(repo.getId());
            return publicGroup;
        }
        catch (Exception e) {
            this.getLogger().error("Unable to setup flexmojos repository properly", (Throwable)e);
            return null;
        }
    }

    private void setupRouting(GroupRepository group, Repository repo) {
        try {
            this.repositoryMapper.addMapping(new RepositoryPathMapping(this.idGenerator.generateId(), RepositoryPathMapping.MappingType.INCLUSION, group.getId(), Arrays.asList(".*/org/sonatype/flexmojos/.*"), Arrays.asList(repo.getId())));
            this.repositoryMapper.addMapping(new RepositoryPathMapping(this.idGenerator.generateId(), RepositoryPathMapping.MappingType.INCLUSION, group.getId(), Arrays.asList(".*/com/adobe/.*"), Arrays.asList(repo.getId())));
            this.repositoryMapper.addMapping(new RepositoryPathMapping(this.idGenerator.generateId(), RepositoryPathMapping.MappingType.BLOCKING, group.getId(), Arrays.asList(".*/com/adobe/.*-sources.jar"), null));
        }
        catch (ConfigurationException e) {
            this.getLogger().error("Unable to setup flexmojos routing properly", (Throwable)e);
        }
    }

    private Repository createFlexmojosRepository() {
        this.getLogger().info("Default Flexmojos repository is missing, creating it.");
        try {
            RepositoryTemplate template = (RepositoryTemplate)this.templateProvider.getTemplateById("default_proxy_release");
            template.getConfigurableRepository().setId("flexmojos");
            template.getConfigurableRepository().setName("Flexmojos Repository");
            Repository repo = template.create();
            this.repositoryRegistry.addRepository(repo);
            return repo;
        }
        catch (Exception e) {
            this.getLogger().error("Unable to setup flexmojos repository properly", (Throwable)e);
            return null;
        }
    }
}

