/*
 * Decompiled with CFR 0.152.
 */
package net.florianschoppmann.java.futures;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.florianschoppmann.java.futures.CheckedFunction;
import net.florianschoppmann.java.futures.Futures;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FuturesTest {
    private static final int DEFAULT_FAILURE = 9;
    private static final int INITIALLY_FAILED = 10;
    private static final int CLOSE_FAILED = 11;
    private static final int APPLY_FAILED = 12;
    private static final int COMPOSE_FAILED = 13;
    private static final int NEW_FUTURE_FAILED = 14;
    private static final int WHEN_COMPLETE_FAILED = 15;
    private static final int DEFAULT_RESULT = 100;
    private static final Executor CALLING_THREAD_EXECUTOR = Runnable::run;

    private static Throwable extractException(CompletableFuture<?> future) {
        Assert.assertTrue((boolean)future.isDone());
        AtomicReference failureReference = new AtomicReference();
        future.whenComplete((result, failure) -> failureReference.set(failure));
        Throwable throwable = (Throwable)failureReference.get();
        Assert.assertNotNull((Object)throwable);
        return throwable;
    }

    private static void assertSuccessfulCollect(Function<Iterable<? extends CompletionStage<Integer>>, CompletableFuture<List<Integer>>> function) {
        CompletableFuture<Integer> first = new CompletableFuture<Integer>();
        CompletableFuture<Integer> second = new CompletableFuture<Integer>();
        CompletableFuture<List<Integer>> list = function.apply(Arrays.asList(first, second));
        first.complete(1);
        Assert.assertFalse((boolean)list.isDone());
        second.complete(2);
        Assert.assertTrue((boolean)list.isDone());
        Assert.assertEquals((Collection)list.join(), Arrays.asList(1, 2));
    }

    @Test
    public void shortCircuitCollectEarlyFail() {
        CompletableFuture first = new CompletableFuture();
        CompletableFuture second = new CompletableFuture();
        CompletableFuture list = Futures.shortCircuitCollect(Arrays.asList(first, second));
        first.completeExceptionally(new ExpectedException(9));
        Assert.assertTrue((boolean)list.isCompletedExceptionally());
        FuturesTest.assertCompletedWithComplEx(list, 9, new int[0]);
    }

    @Test
    public void shortCircuitCollectSuccess() {
        FuturesTest.assertSuccessfulCollect(Futures::shortCircuitCollect);
    }

    private static <T> CompletableFuture<T> assertNoShortCircuit(TriFunction<CompletableFuture<Integer>, CompletableFuture<Integer>, CompletableFuture<Integer>, CompletableFuture<T>> function) {
        CompletableFuture first = new CompletableFuture();
        CompletableFuture second = new CompletableFuture();
        CompletableFuture<Integer> third = new CompletableFuture<Integer>();
        CompletableFuture<T> combinedFuture = function.apply(first, second, third);
        second.completeExceptionally(new ExpectedException(2));
        first.completeExceptionally(new ExpectedException(1));
        Assert.assertFalse((boolean)combinedFuture.isDone());
        third.complete(3);
        Assert.assertTrue((boolean)combinedFuture.isCompletedExceptionally());
        FuturesTest.assertCompletedWithComplEx(combinedFuture, 1, new int[0]);
        CompletableFuture zeroth = Futures.completedExceptionally((Throwable)new CompletionException(new ExpectedException(0)));
        FuturesTest.assertCompletedWithComplEx(function.apply(zeroth, first, second), 0, new int[0]);
        return combinedFuture;
    }

    @Test
    public void collectFailure() {
        FuturesTest.assertNoShortCircuit((first, second, third) -> CompletableFuture.allOf(first, second, third));
        FuturesTest.assertNoShortCircuit((first, second, third) -> Futures.collect(Arrays.asList(first, second, third)));
    }

    @Test
    public void collectSuccess() {
        FuturesTest.assertSuccessfulCollect(Futures::collect);
    }

    private static Integer throwExpectedError() {
        throw new ExpectedError();
    }

    private static Integer throwExpectedException() {
        throw new ExpectedException(9);
    }

    private static void assertSupplyError(CompletableFuture<?> future) {
        Assert.assertTrue((boolean)future.isCompletedExceptionally());
        Throwable actualThrowable = FuturesTest.extractException(future);
        Assert.assertTrue((boolean)(actualThrowable instanceof CompletionException));
        Throwable cause = actualThrowable.getCause();
        Assert.assertTrue((boolean)(cause instanceof ExpectedError));
    }

    @Test
    public void supplyError() {
        FuturesTest.assertSupplyError(CompletableFuture.supplyAsync(FuturesTest::throwExpectedError, Runnable::run));
        FuturesTest.assertSupplyError(Futures.supply(FuturesTest::throwExpectedError));
    }

    private static void assertIsExpectedException(Throwable throwable, int id, int ... suppressedIds) {
        Assert.assertTrue((boolean)(throwable instanceof ExpectedException));
        Assert.assertEquals((int)((ExpectedException)throwable).identifier, (int)id);
        Throwable[] suppressedExceptions = throwable.getSuppressed();
        Assert.assertEquals((int)suppressedExceptions.length, (int)suppressedIds.length);
        for (int i = 0; i < suppressedIds.length; ++i) {
            Assert.assertTrue((boolean)(suppressedExceptions[i] instanceof ExpectedException));
            Assert.assertEquals((int)((ExpectedException)suppressedExceptions[i]).identifier, (int)suppressedIds[i]);
        }
    }

    private static void assertCompletedWithExpEx(CompletableFuture<?> future, int id, int ... suppressedIds) {
        Assert.assertTrue((boolean)future.isCompletedExceptionally());
        FuturesTest.assertIsExpectedException(FuturesTest.extractException(future), id, suppressedIds);
    }

    private static void assertIsCompletionException(Throwable throwable, int id, int ... suppressedIds) {
        Assert.assertTrue((boolean)(throwable instanceof CompletionException));
        FuturesTest.assertIsExpectedException(throwable.getCause(), id, suppressedIds);
    }

    private static void assertCompletedWithComplEx(CompletableFuture<?> future, int id, int ... suppressedIds) {
        Assert.assertTrue((boolean)future.isCompletedExceptionally());
        FuturesTest.assertIsCompletionException(FuturesTest.extractException(future), id, suppressedIds);
    }

    @Test
    public void supplyException() {
        FuturesTest.assertCompletedWithComplEx(CompletableFuture.supplyAsync(FuturesTest::throwExpectedException, CALLING_THREAD_EXECUTOR), 9, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.supply(FuturesTest::throwExpectedException), 9, new int[0]);
    }

    @Test
    public void supplySuccess() {
        CompletableFuture future = Futures.supply(() -> 24);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((int)((Integer)future.join()), (int)24);
    }

    @Test
    public void completedExceptionally() {
        CompletableFuture future = Futures.completedExceptionally((Throwable)new ExpectedException(9));
        FuturesTest.assertCompletedWithExpEx(future, 9, new int[0]);
    }

    @Test
    public void completeWithFailure() {
        CompletableFuture completionStage = new CompletableFuture();
        CompletableFuture future = new CompletableFuture();
        Futures.completeWith(future, completionStage);
        Assert.assertFalse((boolean)future.isDone());
        completionStage.completeExceptionally(new ExpectedException(9));
        FuturesTest.assertCompletedWithExpEx(future, 9, new int[0]);
    }

    @Test
    public void completeWithSuccess() {
        CompletableFuture<Integer> completionStage = new CompletableFuture<Integer>();
        CompletableFuture future = new CompletableFuture();
        Futures.completeWith(future, completionStage);
        Assert.assertFalse((boolean)future.isDone());
        completionStage.complete(24);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((int)((Integer)future.join()), (int)24);
    }

    @Test
    public void unwrapCompletionExceptionWithComplEx() {
        CompletableFuture completionStage = new CompletableFuture();
        CompletableFuture future = Futures.unwrapCompletionException(completionStage);
        Assert.assertFalse((boolean)future.isDone());
        completionStage.completeExceptionally(new CompletionException(new ExpectedException(9)));
        FuturesTest.assertCompletedWithExpEx(future, 9, new int[0]);
    }

    @Test
    public void unwrapCompletionExceptionNoCause() {
        CompletableFuture completionStage = new CompletableFuture();
        CompletableFuture future = Futures.unwrapCompletionException(completionStage);
        Assert.assertFalse((boolean)future.isDone());
        completionStage.completeExceptionally(new CompletionException(null));
        Assert.assertTrue((boolean)future.isCompletedExceptionally());
        Throwable throwable = FuturesTest.extractException(future);
        Assert.assertTrue((boolean)(throwable instanceof CompletionException));
        Assert.assertNull((Object)throwable.getCause());
    }

    @Test
    public void unwrapCompletionExceptionFailure() {
        CompletableFuture completionStage = new CompletableFuture();
        CompletableFuture future = Futures.unwrapCompletionException(completionStage);
        Assert.assertFalse((boolean)future.isDone());
        completionStage.completeExceptionally(new ExpectedException(9));
        FuturesTest.assertCompletedWithExpEx(future, 9, new int[0]);
    }

    @Test
    public void unwrapCompletionExceptionSuccess() {
        CompletableFuture<Integer> completionStage = new CompletableFuture<Integer>();
        CompletableFuture future = Futures.unwrapCompletionException(completionStage);
        Assert.assertFalse((boolean)future.isDone());
        completionStage.complete(25);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((int)((Integer)future.join()), (int)25);
    }

    private static int identity(int number) {
        return number;
    }

    private static int increment(int number) {
        return number + 1;
    }

    private static <T> T takeIntAndThrow(int number) {
        throw new ExpectedException(9);
    }

    @Test
    public void thenApplyFailure() {
        CompletableFuture failedFuture = Futures.completedExceptionally((Throwable)new ExpectedException(1));
        FuturesTest.assertCompletedWithComplEx(failedFuture.thenApply(FuturesTest::identity), 1, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenApply((CompletionStage)failedFuture, FuturesTest::identity), 1, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenApplyAsync((CompletionStage)failedFuture, FuturesTest::identity, (Executor)CALLING_THREAD_EXECUTOR), 1, new int[0]);
        CompletableFuture<Integer> oneFuture = CompletableFuture.completedFuture(1);
        FuturesTest.assertCompletedWithComplEx(oneFuture.thenApply(FuturesTest::takeIntAndThrow), 9, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenApply(oneFuture, FuturesTest::takeIntAndThrow), 9, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenApplyAsync(oneFuture, FuturesTest::takeIntAndThrow, (Executor)CALLING_THREAD_EXECUTOR), 9, new int[0]);
    }

    @Test
    public void thenApplySuccess() {
        CompletableFuture<Integer> oneFuture = CompletableFuture.completedFuture(1);
        Assert.assertEquals((int)((Integer)Futures.thenApply(oneFuture, FuturesTest::increment).join()), (int)2);
    }

    private static CompletableFuture<Integer> identityFuture(int number) {
        return CompletableFuture.completedFuture(number);
    }

    private static CompletableFuture<Integer> incrementFuture(int number) {
        return CompletableFuture.completedFuture(FuturesTest.increment(number));
    }

    private static CompletableFuture<Integer> intToFutureCompletedWithExpEx(int number) {
        return Futures.completedExceptionally((Throwable)new ExpectedException(14));
    }

    private static CompletableFuture<Integer> intToFutureCompletedWithComplEx(int number) {
        return Futures.completedExceptionally((Throwable)new CompletionException(new ExpectedException(14)));
    }

    @Test
    public void thenComposeFailure() {
        CompletableFuture failedFuture = Futures.completedExceptionally((Throwable)new ExpectedException(1));
        FuturesTest.assertCompletedWithComplEx(failedFuture.thenCompose(FuturesTest::identityFuture), 1, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenCompose((CompletionStage)failedFuture, FuturesTest::identityFuture), 1, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenComposeAsync((CompletionStage)failedFuture, FuturesTest::identityFuture, (Executor)CALLING_THREAD_EXECUTOR), 1, new int[0]);
        CompletableFuture<Integer> oneFuture = CompletableFuture.completedFuture(1);
        FuturesTest.assertCompletedWithComplEx(oneFuture.thenCompose(FuturesTest::takeIntAndThrow), 9, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenCompose(oneFuture, FuturesTest::takeIntAndThrow), 9, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenComposeAsync(oneFuture, FuturesTest::takeIntAndThrow, (Executor)CALLING_THREAD_EXECUTOR), 9, new int[0]);
        FuturesTest.assertCompletedWithComplEx(oneFuture.thenCompose(FuturesTest::intToFutureCompletedWithExpEx), 14, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenCompose(oneFuture, FuturesTest::intToFutureCompletedWithExpEx), 14, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenComposeAsync(oneFuture, FuturesTest::intToFutureCompletedWithExpEx, (Executor)CALLING_THREAD_EXECUTOR), 14, new int[0]);
        FuturesTest.assertCompletedWithComplEx(oneFuture.thenCompose(FuturesTest::intToFutureCompletedWithComplEx), 14, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenCompose(oneFuture, FuturesTest::intToFutureCompletedWithComplEx), 14, new int[0]);
        FuturesTest.assertCompletedWithComplEx(Futures.thenComposeAsync(oneFuture, FuturesTest::intToFutureCompletedWithComplEx, (Executor)CALLING_THREAD_EXECUTOR), 14, new int[0]);
    }

    @Test
    public void thenComposeSuccess() {
        CompletableFuture<Integer> oneFuture = CompletableFuture.completedFuture(1);
        Assert.assertEquals((int)((Integer)Futures.thenCompose(oneFuture, FuturesTest::incrementFuture).join()), (int)2);
    }

    private static void assertWrappedExpectedExceptionCallback(Function<TryContainer, CompletableFuture<Integer>> function, int id) {
        TryContainer tryContainer = new TryContainer();
        CompletableFuture<Integer> whenCompleteFuture = function.apply(tryContainer);
        FuturesTest.assertCompletedWithComplEx(whenCompleteFuture, id, new int[0]);
        Try integerTry = tryContainer.integerTry;
        Assert.assertNotNull((Object)integerTry);
        Assert.assertTrue((boolean)(integerTry instanceof Failure));
        Throwable throwable = ((Failure)integerTry).throwable;
        FuturesTest.assertIsExpectedException(throwable, id, new int[0]);
    }

    private static void assertThrowingSuccessCallback(Function<TryContainer, CompletableFuture<Integer>> function, int id) {
        TryContainer tryContainer = new TryContainer();
        CompletableFuture<Integer> whenCompleteFuture = function.apply(tryContainer);
        FuturesTest.assertCompletedWithComplEx(whenCompleteFuture, id, new int[0]);
        Try integerTry = tryContainer.integerTry;
        Assert.assertNotNull((Object)integerTry);
        Assert.assertEquals((Object)integerTry, new Success(1));
    }

    @Test
    public void whenCompleteFailure() {
        CompletableFuture failedFuture = Futures.completedExceptionally((Throwable)new ExpectedException(10));
        FuturesTest.assertWrappedExpectedExceptionCallback(container -> failedFuture.whenComplete((x$0, x$1) -> ((TryContainer)container).consume(x$0, x$1)), 10);
        FuturesTest.assertWrappedExpectedExceptionCallback(container -> Futures.whenComplete((CompletionStage)failedFuture, (x$0, x$1) -> ((TryContainer)container).consume(x$0, x$1)), 10);
        FuturesTest.assertWrappedExpectedExceptionCallback(container -> Futures.whenCompleteAsync((CompletionStage)failedFuture, (x$0, x$1) -> ((TryContainer)container).consume(x$0, x$1), (Executor)CALLING_THREAD_EXECUTOR), 10);
        CompletableFuture<Integer> oneFuture = CompletableFuture.completedFuture(1);
        FuturesTest.assertThrowingSuccessCallback(container -> oneFuture.whenComplete((x$0, x$1) -> ((TryContainer)container).consumeAndThrow(x$0, x$1)), 15);
        FuturesTest.assertThrowingSuccessCallback(container -> Futures.whenComplete((CompletionStage)oneFuture, (x$0, x$1) -> ((TryContainer)container).consumeAndThrow(x$0, x$1)), 15);
        FuturesTest.assertThrowingSuccessCallback(container -> Futures.whenCompleteAsync((CompletionStage)oneFuture, (x$0, x$1) -> ((TryContainer)container).consumeAndThrow(x$0, x$1), (Executor)CALLING_THREAD_EXECUTOR), 15);
    }

    private static void assertSuccessCallback(Function<TryContainer, CompletableFuture<Integer>> function, int result) {
        TryContainer tryContainer = new TryContainer();
        CompletableFuture<Integer> whenCompleteFuture = function.apply(tryContainer);
        Assert.assertTrue((boolean)whenCompleteFuture.isDone());
        Assert.assertEquals((int)whenCompleteFuture.join(), (int)result);
        Try localResultAttempt = tryContainer.integerTry;
        Assert.assertNotNull((Object)localResultAttempt);
        Assert.assertEquals((Object)localResultAttempt, new Success(result));
    }

    @Test
    public void whenCompleteSuccess() {
        CompletableFuture<Integer> oneFuture = CompletableFuture.completedFuture(1);
        FuturesTest.assertSuccessCallback(blabla -> oneFuture.whenComplete((x$0, x$1) -> ((TryContainer)blabla).consume(x$0, x$1)), 1);
        FuturesTest.assertSuccessCallback(blabla -> Futures.whenComplete((CompletionStage)oneFuture, (x$0, x$1) -> ((TryContainer)blabla).consume(x$0, x$1)), 1);
        FuturesTest.assertSuccessCallback(blabla -> Futures.whenCompleteAsync((CompletionStage)oneFuture, (x$0, x$1) -> ((TryContainer)blabla).consume(x$0, x$1), (Executor)CALLING_THREAD_EXECUTOR), 1);
    }

    @Test
    public void translateException() {
        CompletableFuture failedFuture = Futures.completedExceptionally((Throwable)new ExpectedException(10));
        AtomicReference idReference = new AtomicReference();
        FuturesTest.assertCompletedWithExpEx(Futures.translateException((CompletionStage)failedFuture, throwable -> {
            idReference.set(((ExpectedException)throwable).identifier);
            return new ExpectedException(2);
        }), 2, new int[0]);
        Assert.assertEquals((int)((Integer)idReference.get()), (int)10);
        idReference.set(null);
        CompletableFuture throwingTranslatedFuture = Futures.translateException((CompletionStage)failedFuture, throwable -> {
            idReference.set(((ExpectedException)throwable).identifier);
            throw new ExpectedException(3);
        });
        FuturesTest.assertCompletedWithComplEx(throwingTranslatedFuture, 3, new int[0]);
        Assert.assertEquals((int)((Integer)idReference.get()), (int)10);
        idReference.set(null);
        CompletableFuture nullFuture = Futures.translateException((CompletionStage)failedFuture, throwable -> {
            idReference.set(((ExpectedException)throwable).identifier);
            return null;
        });
        Assert.assertTrue((boolean)nullFuture.isCompletedExceptionally());
        Throwable throwable2 = FuturesTest.extractException(nullFuture);
        Assert.assertTrue((boolean)(throwable2 instanceof CompletionException));
        Assert.assertTrue((boolean)(throwable2.getCause() instanceof NullPointerException));
        CompletableFuture<Integer> oneFuture = CompletableFuture.completedFuture(1);
        CompletableFuture translatedFuture = Futures.translateException(oneFuture, Function.identity());
        Assert.assertTrue((boolean)translatedFuture.isDone());
        Assert.assertEquals((int)((Integer)translatedFuture.join()), (int)1);
    }

    @Test
    public void transformCompletionStage() {
        CompletableFuture completionStage = Futures.completedExceptionally((Throwable)new ExpectedException(10));
        FuturesTest.assertCompletedWithExpEx(Futures.transformCompletionStage(ignored -> completionStage, (result, failure, future) -> {}), 10, new int[0]);
    }

    private static void assertTryWithResourceResult(CompletableFuture<Integer> future, AutoClosableImpl autoClosable, InitialStageKind initialStageKind, @Nullable int[] expectedExceptionIds) {
        if (expectedExceptionIds == null) {
            Assert.assertTrue((boolean)future.isDone());
            Assert.assertEquals((int)future.join(), (int)100);
        } else {
            assert (expectedExceptionIds.length > 0);
            int[] suppressedIds = Arrays.copyOfRange(expectedExceptionIds, 1, expectedExceptionIds.length);
            FuturesTest.assertCompletedWithComplEx(future, expectedExceptionIds[0], suppressedIds);
        }
        if (initialStageKind == InitialStageKind.SUCCESS) {
            Assert.assertFalse((boolean)autoClosable.open);
        }
    }

    @DataProvider
    Object[][] dataForThenApplyWithResource() {
        return new Object[][]{{InitialStageKind.NULL, Behavior.SUCCESS, Behavior.SUCCESS, null}, {InitialStageKind.NULL, Behavior.EXCEPTION, Behavior.SUCCESS, new int[]{12}}, {InitialStageKind.FAILED, Behavior.SUCCESS, Behavior.SUCCESS, new int[]{10}}, {InitialStageKind.SUCCESS, Behavior.SUCCESS, Behavior.SUCCESS, null}, {InitialStageKind.SUCCESS, Behavior.SUCCESS, Behavior.EXCEPTION, new int[]{11}}, {InitialStageKind.SUCCESS, Behavior.EXCEPTION, Behavior.SUCCESS, new int[]{12}}, {InitialStageKind.SUCCESS, Behavior.EXCEPTION, Behavior.EXCEPTION, new int[]{12, 11}}};
    }

    @Test(dataProvider="dataForThenApplyWithResource")
    public void thenApplyWithResourceAsync(InitialStageKind initialStageKind, Behavior applyBehavior, Behavior closeBehavior, @Nullable int[] expectedExceptionIds) {
        AutoClosableImpl autoClosable = new AutoClosableImpl(closeBehavior);
        CompletableFuture<AutoClosableImpl> initialStage = initialStageKind.newFuture(autoClosable);
        CompletableFuture future = Futures.thenApplyWithResourceAsync(initialStage, (CheckedFunction)(applyBehavior == Behavior.EXCEPTION ? ignored -> {
            throw new ExpectedException(12);
        } : ignored -> 100), (Executor)CALLING_THREAD_EXECUTOR);
        FuturesTest.assertTryWithResourceResult(future, autoClosable, initialStageKind, expectedExceptionIds);
    }

    @DataProvider
    public Object[][] dataForThenComposeWithResource() {
        return new Object[][]{{InitialStageKind.NULL, Behavior.SUCCESS, Behavior.SUCCESS, WrapKind.DONT_WRAP, Behavior.SUCCESS, null}, {InitialStageKind.NULL, Behavior.SUCCESS, Behavior.EXCEPTION, WrapKind.DONT_WRAP, Behavior.SUCCESS, new int[]{14}}, {InitialStageKind.NULL, Behavior.EXCEPTION, Behavior.SUCCESS, WrapKind.DONT_WRAP, Behavior.SUCCESS, new int[]{13}}, {InitialStageKind.FAILED, Behavior.SUCCESS, Behavior.SUCCESS, WrapKind.DONT_WRAP, Behavior.SUCCESS, new int[]{10}}, {InitialStageKind.SUCCESS, Behavior.SUCCESS, Behavior.SUCCESS, WrapKind.DONT_WRAP, Behavior.SUCCESS, null}, {InitialStageKind.SUCCESS, Behavior.SUCCESS, Behavior.SUCCESS, WrapKind.DONT_WRAP, Behavior.EXCEPTION, new int[]{11}}, {InitialStageKind.SUCCESS, Behavior.SUCCESS, Behavior.EXCEPTION, WrapKind.DONT_WRAP, Behavior.SUCCESS, new int[]{14}}, {InitialStageKind.SUCCESS, Behavior.SUCCESS, Behavior.EXCEPTION, WrapKind.DONT_WRAP, Behavior.EXCEPTION, new int[]{14, 11}}, {InitialStageKind.SUCCESS, Behavior.SUCCESS, Behavior.EXCEPTION, WrapKind.WRAP, Behavior.EXCEPTION, new int[]{14, 11}}, {InitialStageKind.SUCCESS, Behavior.EXCEPTION, Behavior.SUCCESS, WrapKind.DONT_WRAP, Behavior.SUCCESS, new int[]{13}}, {InitialStageKind.SUCCESS, Behavior.EXCEPTION, Behavior.SUCCESS, WrapKind.DONT_WRAP, Behavior.EXCEPTION, new int[]{13, 11}}};
    }

    private static CompletableFuture<Integer> newComposeWithResourceFuture(Behavior futureBehavior, WrapKind wrapKind) {
        if (futureBehavior == Behavior.EXCEPTION) {
            RuntimeException throwable = wrapKind == WrapKind.WRAP ? new CompletionException(new ExpectedException(14)) : new ExpectedException(14);
            return Futures.completedExceptionally((Throwable)throwable);
        }
        return CompletableFuture.completedFuture(100);
    }

    @Test(dataProvider="dataForThenComposeWithResource")
    public void thenComposeWithResource(InitialStageKind initialStageKind, Behavior composeBehavior, Behavior futureBehavior, WrapKind wrapFutureException, Behavior closeBehavior, @Nullable int[] expectedExceptionIds) {
        AutoClosableImpl autoClosable = new AutoClosableImpl(closeBehavior);
        CompletableFuture<AutoClosableImpl> initialStage = initialStageKind.newFuture(autoClosable);
        CompletableFuture future = Futures.thenComposeWithResource(initialStage, (CheckedFunction)(composeBehavior == Behavior.EXCEPTION ? ignored -> {
            throw new ExpectedException(13);
        } : ignored -> FuturesTest.newComposeWithResourceFuture(futureBehavior, wrapFutureException)));
        FuturesTest.assertTryWithResourceResult(future, autoClosable, initialStageKind, expectedExceptionIds);
    }

    @Test
    public void decode() {
        CompletionException exception = new CompletionException(null);
        Assert.assertSame((Object)Futures.decode((Throwable)exception), (Object)exception);
    }

    static enum WrapKind {
        WRAP,
        DONT_WRAP;

    }

    static enum Behavior {
        SUCCESS,
        EXCEPTION;

    }

    static enum InitialStageKind {
        NULL{

            @Override
            CompletableFuture<AutoClosableImpl> newFuture(AutoClosableImpl autoClosable) {
                return CompletableFuture.completedFuture(null);
            }
        }
        ,
        SUCCESS{

            @Override
            CompletableFuture<AutoClosableImpl> newFuture(AutoClosableImpl autoClosable) {
                return CompletableFuture.completedFuture(autoClosable);
            }
        }
        ,
        FAILED{

            @Override
            CompletableFuture<AutoClosableImpl> newFuture(AutoClosableImpl autoClosable) {
                return Futures.completedExceptionally((Throwable)new ExpectedException(10));
            }
        };


        abstract CompletableFuture<AutoClosableImpl> newFuture(AutoClosableImpl var1);
    }

    private static final class AutoClosableImpl
    implements AutoCloseable {
        private final Behavior closeBehavior;
        private boolean open = true;

        private AutoClosableImpl(Behavior closeBehavior) {
            this.closeBehavior = closeBehavior;
        }

        @Override
        public void close() {
            this.open = false;
            if (this.closeBehavior == Behavior.EXCEPTION) {
                throw new ExpectedException(11);
            }
        }
    }

    private static final class TryContainer {
        @Nullable
        private volatile Try<Integer> integerTry;

        private TryContainer() {
        }

        private void consume(@Nullable Integer result, @Nullable Throwable throwable) {
            assert (result != null || throwable != null);
            this.integerTry = throwable != null ? new Failure(throwable) : new Success(result);
        }

        private void consumeAndThrow(@Nullable Integer result, @Nullable Throwable throwable) {
            this.consume(result, throwable);
            throw new ExpectedException(15);
        }
    }

    private static final class Failure<T>
    extends Try<T> {
        private final Throwable throwable;

        private Failure(Throwable throwable) {
            this.throwable = throwable;
        }
    }

    private static final class Success<T>
    extends Try<T> {
        private final T result;

        private Success(T result) {
            this.result = result;
        }

        public boolean equals(@Nullable Object otherObject) {
            return this == otherObject || otherObject instanceof Success && this.result.equals(((Success)otherObject).result);
        }

        public int hashCode() {
            return this.result.hashCode();
        }
    }

    private static abstract class Try<T> {
        private Try() {
            assert (this.getClass().equals(Success.class) || this.getClass().equals(Failure.class));
        }
    }

    @FunctionalInterface
    private static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }

    private static final class ExpectedError
    extends Error {
        private static final long serialVersionUID = -3686404494241921008L;

        private ExpectedError() {
            super("This is an expected error.");
        }
    }

    private static final class ExpectedException
    extends RuntimeException {
        private static final long serialVersionUID = -7681392744759739602L;
        private final int identifier;

        private ExpectedException(int identifier) {
            super("This is an expected exception.");
            this.identifier = identifier;
        }
    }
}

