/*
 * Decompiled with CFR 0.152.
 */
package net.goui.flogger.testing.junit4;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.goui.flogger.testing.LevelClass;
import net.goui.flogger.testing.SetLogLevel;
import net.goui.flogger.testing.api.LogInterceptor;
import net.goui.flogger.testing.api.TestingApi;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class FloggerTestRule
extends TestingApi<FloggerTestRule>
implements TestRule {
    public static FloggerTestRule forClassUnderTest(LevelClass level) {
        Class<?> caller = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        return FloggerTestRule.forClassOrPackage(FloggerTestRule.guessClassUnderTest(caller), level);
    }

    public static FloggerTestRule forPackageUnderTest(LevelClass level) {
        Class<?> caller = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        return FloggerTestRule.forClassOrPackage(FloggerTestRule.guessPackageUnderTest(caller), level);
    }

    public static FloggerTestRule forClass(Class<?> clazz, LevelClass level) {
        return FloggerTestRule.forClassOrPackage(FloggerTestRule.loggerNameOf(clazz), level);
    }

    public static FloggerTestRule forPackage(Package pkg, LevelClass level) {
        return FloggerTestRule.forClassOrPackage(pkg.getName(), level);
    }

    public static FloggerTestRule forClassOrPackage(String loggerName, LevelClass level) {
        return FloggerTestRule.forLevelMap((Map<String, LevelClass>)ImmutableMap.of((Object)loggerName, (Object)level));
    }

    public static FloggerTestRule forLevelMap(Map<String, LevelClass> levelMap) {
        return FloggerTestRule.create(levelMap, null);
    }

    public static FloggerTestRule create(Map<String, LevelClass> levelMap, @Nullable LogInterceptor interceptor) {
        return new FloggerTestRule(levelMap, interceptor);
    }

    private FloggerTestRule(Map<String, LevelClass> levelMap, @Nullable LogInterceptor interceptor) {
        super(levelMap, interceptor);
    }

    protected FloggerTestRule api() {
        return this;
    }

    public Statement apply(final Statement statement, Description description) {
        final ImmutableMap extraLogLevels = FloggerTestRule.getLevelMap((Class)description.getTestClass(), (ImmutableList)((ImmutableList)description.getAnnotations().stream().filter(SetLogLevel.class::isInstance).map(SetLogLevel.class::cast).collect(ImmutableList.toImmutableList())));
        return new Statement(){

            public void evaluate() throws Throwable {
                try (TestingApi.ApiHook unusedCloseable = FloggerTestRule.this.install(true, extraLogLevels);){
                    statement.evaluate();
                }
            }
        };
    }
}

