/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

final class CRCBackport {
    private static final int[] crcTable = new int[256];
    private int crc = -1;

    CRCBackport() {
    }

    void reset() {
        this.crc = -1;
    }

    void update(byte[] data, int off, int len) {
        int c = this.crc;
        for (int n = 0; n < len; ++n) {
            c = crcTable[(c ^ data[off + n]) & 0xFF] ^ c >>> 8;
        }
        this.crc = c;
    }

    void update(int data) {
        this.crc = crcTable[(this.crc ^ data) & 0xFF] ^ this.crc >>> 8;
    }

    int getValue() {
        return ~this.crc;
    }

    static {
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                c = (c & 1) == 1 ? 0xEDB88320 ^ c >>> 1 : (c >>>= 1);
                CRCBackport.crcTable[n] = c;
            }
        }
    }
}

