/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.CRCBackport;
import java.io.IOException;
import java.util.zip.Deflater;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

final class IDATOutputStreamBackport
extends ImageOutputStreamImpl {
    private static final byte[] chunkType = new byte[]{73, 68, 65, 84};
    private final ImageOutputStream stream;
    private final int chunkLength;
    private long startPos;
    private final CRCBackport crc = new CRCBackport();
    private final Deflater def;
    private final byte[] buf = new byte[512];
    private final byte[] wbuf1 = new byte[1];
    private int bytesRemaining;

    IDATOutputStreamBackport(ImageOutputStream stream, int chunkLength, int deflaterLevel) throws IOException {
        this.stream = stream;
        this.chunkLength = chunkLength;
        this.def = new Deflater(deflaterLevel);
        this.startChunk();
    }

    private void startChunk() throws IOException {
        this.crc.reset();
        this.startPos = this.stream.getStreamPosition();
        this.stream.writeInt(-1);
        this.crc.update(chunkType, 0, 4);
        this.stream.write(chunkType, 0, 4);
        this.bytesRemaining = this.chunkLength;
    }

    private void finishChunk() throws IOException {
        this.stream.writeInt(this.crc.getValue());
        long pos = this.stream.getStreamPosition();
        this.stream.seek(this.startPos);
        this.stream.writeInt((int)(pos - this.startPos) - 12);
        this.stream.seek(pos);
        try {
            this.stream.flushBefore(pos);
        }
        catch (IOException e) {
            this.startPos = this.stream.getStreamPosition();
            throw e;
        }
    }

    @Override
    public int read() throws IOException {
        throw new RuntimeException("Method not available");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        throw new RuntimeException("Method not available");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (!this.def.finished()) {
            this.def.setInput(b, off, len);
            while (!this.def.needsInput()) {
                this.deflate();
            }
        }
    }

    void deflate() throws IOException {
        int len = this.def.deflate(this.buf, 0, this.buf.length);
        int off = 0;
        while (len > 0) {
            if (this.bytesRemaining == 0) {
                this.finishChunk();
                this.startChunk();
            }
            int nbytes = Math.min(len, this.bytesRemaining);
            this.crc.update(this.buf, off, nbytes);
            this.stream.write(this.buf, off, nbytes);
            off += nbytes;
            len -= nbytes;
            this.bytesRemaining -= nbytes;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.wbuf1[0] = (byte)b;
        this.write(this.wbuf1, 0, 1);
    }

    void finish() throws IOException {
        try {
            if (!this.def.finished()) {
                this.def.finish();
                while (!this.def.finished()) {
                    this.deflate();
                }
            }
            this.finishChunk();
        }
        finally {
            this.def.end();
        }
    }

    @Override
    protected void finalize() throws Throwable {
    }
}

