/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.PNGImageWriterBackport;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;

public class PNGImageWriterSpiBackport
extends ImageWriterSpi {
    private static final String vendorName = "The Interwebs";
    private static final String version = "1.0";
    private static final String[] names = new String[]{"png", "PNG"};
    private static final String[] suffixes = new String[]{"png"};
    private static final String[] MIMETypes = new String[]{"image/png", "image/x-png"};
    private static final String writerClassName = "com.sun.imageio.plugins.png.PNGImageWriterBackport";
    private static final String[] readerSpiNames = new String[]{"com.sun.imageio.plugins.png.PNGImageReaderSpi"};

    public PNGImageWriterSpiBackport() {
        super(vendorName, version, names, suffixes, MIMETypes, writerClassName, new Class[]{ImageOutputStream.class}, readerSpiNames, false, null, null, null, null, true, "javax_imageio_png_1.0", "com.sun.imageio.plugins.png.PNGMetadataFormat", null, null);
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier type) {
        SampleModel sampleModel = type.getSampleModel();
        ColorModel colorModel = type.getColorModel();
        int[] sampleSize = sampleModel.getSampleSize();
        int bitDepth = sampleSize[0];
        for (int i = 1; i < sampleSize.length; ++i) {
            if (sampleSize[i] <= bitDepth) continue;
            bitDepth = sampleSize[i];
        }
        if (bitDepth < 1 || bitDepth > 16) {
            return false;
        }
        int numBands = sampleModel.getNumBands();
        if (numBands < 1 || numBands > 4) {
            return false;
        }
        boolean hasAlpha = colorModel.hasAlpha();
        if (colorModel instanceof IndexColorModel) {
            return true;
        }
        if ((numBands == 1 || numBands == 3) && hasAlpha) {
            return false;
        }
        return numBands != 2 && numBands != 4 || hasAlpha;
    }

    @Override
    public String getDescription(Locale locale) {
        return "JDK9 Backport PNG image writer";
    }

    @Override
    public ImageWriter createWriterInstance(Object extension) {
        return new PNGImageWriterBackport(this);
    }

    @Override
    public void onRegistration(ServiceRegistry registry, Class<?> category) {
        Iterator<ImageWriterSpi> others = registry.getServiceProviders(ImageWriterSpi.class, false);
        block0: while (others.hasNext()) {
            ImageWriterSpi other = others.next();
            if (other == this) continue;
            for (String formatName : other.getFormatNames()) {
                if (!"png".equals(formatName)) continue;
                registry.setOrdering(ImageWriterSpi.class, this, other);
                continue block0;
            }
        }
    }
}

