/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.openapi.core.autoconfigure;

import java.util.Collections;
import net.guerlab.cloud.openapi.core.properties.OpenApiProperties;
import net.guerlab.cloud.security.core.AuthorizePathProvider;
import net.guerlab.cloud.security.core.SimpleAuthorizePathProvider;
import net.guerlab.cloud.security.core.autoconfigure.AuthorizePathAutoconfigure;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.SpringDocConfigProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OpenApiProperties.class})
@AutoConfigureBefore(value={AuthorizePathAutoconfigure.class})
public class OpenApiAutoconfigure {
    private static final Logger log = LoggerFactory.getLogger(OpenApiAutoconfigure.class);

    @Bean
    @ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
    public AuthorizePathProvider openApiAuthorizePathProvider(SpringDocConfigProperties properties) {
        String path = StringUtils.trimToEmpty((String)properties.getApiDocs().getPath()) + "/**";
        return new SimpleAuthorizePathProvider(Collections.singletonList(path));
    }
}

