/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.sentinel.webmvc.autoconfigure;

import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.guerlab.commons.exception.ApplicationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class WebmvcExceptionHandlerAutoConfigure {
    @Bean
    public CustomerBlockExceptionHandler customerBlockExceptionHandler() {
        return new CustomerBlockExceptionHandler();
    }

    public static class CustomerBlockExceptionHandler
    implements BlockExceptionHandler {
        private static final String DEFAULT_BLOCK_MSG_PREFIX = "Blocked by Sentinel: ";

        public void handle(HttpServletRequest request, HttpServletResponse response, BlockException ex) {
            String queryString;
            if (HttpMethod.GET.matches(request.getMethod()) && (queryString = StringUtils.trimToNull((String)request.getQueryString())) != null) {
                request.getRequestURL().append("?").append(queryString);
            }
            throw new ApplicationException(DEFAULT_BLOCK_MSG_PREFIX + ex.getClass().getSimpleName(), HttpStatus.TOO_MANY_REQUESTS.value());
        }
    }
}

