/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.web.webmvc.autoconfigure;

import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import net.guerlab.cloud.core.converter.AutoLoadConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
@ConditionalOnBean(value={RequestMappingHandlerAdapter.class})
public class ConverterConfig {
    @Autowired
    public void addConverter(RequestMappingHandlerAdapter handlerAdapter) {
        WebBindingInitializer webBindingInitializer = handlerAdapter.getWebBindingInitializer();
        if (!(webBindingInitializer instanceof ConfigurableWebBindingInitializer)) {
            return;
        }
        ConfigurableWebBindingInitializer initializer = (ConfigurableWebBindingInitializer)webBindingInitializer;
        ConversionService conversionService = initializer.getConversionService();
        if (initializer.getConversionService() == null || !(conversionService instanceof GenericConversionService)) {
            return;
        }
        GenericConversionService service = (GenericConversionService)conversionService;
        StreamSupport.stream(ServiceLoader.load(AutoLoadConverter.class).spliterator(), false).forEach(arg_0 -> ((GenericConversionService)service).addConverter(arg_0));
    }
}

