/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.web.webmvc.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.guerlab.cloud.core.autoconfigure.ObjectMapperAutoConfigure;
import net.guerlab.cloud.security.core.properties.CorsProperties;
import net.guerlab.commons.collection.CollectionUtil;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

@AutoConfiguration(after={ObjectMapperAutoConfigure.class})
@EnableConfigurationProperties(value={CorsProperties.class})
public class WebMvcAutoConfigure {

    @AutoConfiguration
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    public static class MvcAutoConfigure
    implements WebMvcConfigurer {
        private final ObjectMapper objectMapper;
        private final LocaleChangeInterceptor localeChangeInterceptor;

        public MvcAutoConfigure(ObjectMapper objectMapper, LocaleChangeInterceptor localeChangeInterceptor) {
            this.objectMapper = objectMapper;
            this.localeChangeInterceptor = localeChangeInterceptor;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor);
        }

        public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            if (CollectionUtil.isEmpty(converters)) {
                converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(this.objectMapper));
                converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
                return;
            }
            for (HttpMessageConverter<?> converter : converters) {
                if (converter instanceof MappingJackson2XmlHttpMessageConverter || !(converter instanceof AbstractJackson2HttpMessageConverter)) continue;
                ((AbstractJackson2HttpMessageConverter)converter).setObjectMapper(this.objectMapper);
            }
        }
    }
}

