/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.web.webmvc.autoconfigure;

import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.guerlab.cloud.commons.exception.handler.ResponseBuilder;
import net.guerlab.cloud.commons.exception.handler.StackTracesHandler;
import net.guerlab.cloud.web.core.autoconfigure.GlobalExceptionHandlerAutoConfigure;
import net.guerlab.cloud.web.core.exception.handler.GlobalExceptionLogger;
import net.guerlab.cloud.web.core.properties.GlobalExceptionProperties;
import net.guerlab.cloud.web.webmvc.autoconfigure.CustomerErrorController;
import net.guerlab.cloud.web.webmvc.exception.handler.WebMvcGlobalExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@AutoConfiguration(before={ErrorMvcAutoConfiguration.class}, after={GlobalExceptionHandlerAutoConfigure.class})
public class WebMvcGlobalExceptionHandlerAutoConfigure {
    private static final Logger log = LoggerFactory.getLogger(WebMvcGlobalExceptionHandlerAutoConfigure.class);

    @Bean
    @ConditionalOnMissingBean(value={ErrorController.class}, search=SearchStrategy.CURRENT)
    public AbstractErrorController basicErrorController(ErrorAttributes errorAttributes, ObjectProvider<ErrorViewResolver> errorViewResolvers) {
        log.debug("create CustomerErrorController");
        return new CustomerErrorController(errorAttributes, errorViewResolvers.orderedStream().collect(Collectors.toList()));
    }

    @RestControllerAdvice
    public static class DefaultWebMvcGlobalExceptionHandler
    extends WebMvcGlobalExceptionHandler {
        public DefaultWebMvcGlobalExceptionHandler(MessageSource messageSource, StackTracesHandler stackTracesHandler, GlobalExceptionLogger globalExceptionLogger, GlobalExceptionProperties globalExceptionProperties) {
            super(messageSource, stackTracesHandler, globalExceptionLogger, ServiceLoader.load(ResponseBuilder.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList()), globalExceptionProperties);
        }
    }
}

