/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.web.webmvc.autoconfigure;

import net.guerlab.cloud.web.core.properties.I18nProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@AutoConfiguration
@ConditionalOnClass(value={LocaleResolver.class, LocaleChangeInterceptor.class, SessionLocaleResolver.class})
@EnableConfigurationProperties(value={I18nProperties.class})
public class WebMvcI18nAutoConfigure {
    @Bean
    @ConditionalOnMissingBean
    public LocaleResolver localeResolver(I18nProperties properties) {
        SessionLocaleResolver resolver = new SessionLocaleResolver();
        resolver.setDefaultLocale(properties.getDefaultLocale());
        return resolver;
    }

    @Bean
    @ConditionalOnMissingBean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        return new LocaleChangeInterceptor();
    }
}

