/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.web.webmvc.autoconfigure;

import java.lang.reflect.Method;
import net.guerlab.cloud.core.result.Succeed;
import net.guerlab.cloud.web.core.response.ResponseBodyWrapperSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@AutoConfiguration
@ConditionalOnClass(value={ResponseBodyAdvice.class})
@ConditionalOnProperty(prefix="spring.web", name={"wrapper-response"}, havingValue="true", matchIfMissing=true)
public class WebMvcResponseAdvisorAutoConfigure {
    private static final Logger log = LoggerFactory.getLogger(WebMvcResponseAdvisorAutoConfigure.class);

    @RestControllerAdvice
    public static class ResponseAdvice
    implements ResponseBodyAdvice<Object> {
        private final ResponseBodyWrapperSupport support;

        public ResponseAdvice(ResponseBodyWrapperSupport support) {
            this.support = support;
        }

        public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
            return this.support.supports(returnType);
        }

        public Object beforeBodyWrite(@Nullable Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
            if (body == null) {
                log.debug("wrapper with null body");
                return new Succeed();
            }
            if (this.support.noConvertObject(body, returnType)) {
                log.debug("un wrapper with noConvertObject, body class is {}", body.getClass());
                return body;
            }
            if (this.matchExcluded(request, returnType.getMethod())) {
                log.debug("un wrapper with matchExcluded");
                return body;
            }
            log.debug("wrap up");
            return new Succeed(body);
        }

        private boolean matchExcluded(ServerHttpRequest request, @Nullable Method method) {
            return this.support.matchExcluded(this.getRequestPath(request), method);
        }

        private String getRequestPath(ServerHttpRequest request) {
            String requestPath = request.getURI().getPath();
            if (request instanceof ServletServerHttpRequest) {
                ServletServerHttpRequest servletServerHttpRequest = (ServletServerHttpRequest)request;
                String contextPath = servletServerHttpRequest.getServletRequest().getContextPath();
                String newRequestPath = requestPath.replaceFirst(contextPath, "");
                log.debug("replace requestPath[form={}, to={}]", (Object)requestPath, (Object)newRequestPath);
                requestPath = newRequestPath;
            }
            return requestPath;
        }
    }
}

