/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.web.webmvc.exception.handler;

import java.util.Collection;
import net.guerlab.cloud.commons.exception.handler.ResponseBuilder;
import net.guerlab.cloud.commons.exception.handler.StackTracesHandler;
import net.guerlab.cloud.core.result.Fail;
import net.guerlab.cloud.web.core.exception.handler.GlobalExceptionHandler;
import net.guerlab.cloud.web.core.exception.handler.GlobalExceptionLogger;
import net.guerlab.cloud.web.core.properties.GlobalExceptionProperties;
import net.guerlab.cloud.web.core.request.RequestHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class WebMvcGlobalExceptionHandler
extends GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(WebMvcGlobalExceptionHandler.class);
    private final GlobalExceptionProperties globalExceptionProperties;

    public WebMvcGlobalExceptionHandler(MessageSource messageSource, StackTracesHandler stackTracesHandler, GlobalExceptionLogger globalExceptionLogger, Collection<ResponseBuilder> builders, GlobalExceptionProperties globalExceptionProperties) {
        super(messageSource, stackTracesHandler, globalExceptionLogger, builders);
        this.globalExceptionProperties = globalExceptionProperties;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Fail<?>> exceptionHandler0(Exception e) {
        String requestMethod = RequestHolder.getRequestMethod();
        String requestPath = RequestHolder.getRequestPath();
        Integer responseStatusCode = RequestHolder.responseStatusCode();
        this.globalExceptionLogger.debug((Throwable)e, requestMethod, requestPath);
        int statusCode = responseStatusCode != null ? responseStatusCode.intValue() : this.globalExceptionProperties.getStatusCode(requestMethod, requestPath);
        return ResponseEntity.status((int)statusCode).body((Object)this.build(e));
    }
}

