/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.web.webmvc.request;

import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebmvcRequestContextHolder
implements net.guerlab.cloud.web.core.request.RequestContextHolder {
    private static final Logger log = LoggerFactory.getLogger(WebmvcRequestContextHolder.class);

    @Nullable
    private static ServletRequestAttributes getServletRequestAttributes() {
        return (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
    }

    @Nullable
    private static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequestAttributes = WebmvcRequestContextHolder.getServletRequestAttributes();
        return servletRequestAttributes != null ? servletRequestAttributes.getRequest() : null;
    }

    private static String parseRequestUri(HttpServletRequest request) {
        String requestUri;
        String contextPath = request.getContextPath();
        Object forwardRequestUri = request.getAttribute("jakarta.servlet.forward.request_uri");
        String string = requestUri = forwardRequestUri == null ? request.getRequestURI() : String.valueOf(forwardRequestUri);
        if (contextPath != null) {
            String newRequestUri = requestUri.replaceFirst(contextPath, "");
            log.debug("replace requestUri[form={}, to={}]", (Object)requestUri, (Object)newRequestUri);
            requestUri = newRequestUri;
        }
        return requestUri;
    }

    @Nullable
    public String getRequestMethod() {
        HttpServletRequest request = WebmvcRequestContextHolder.getRequest();
        return request != null ? request.getMethod() : null;
    }

    @Nullable
    public String getRequestPath() {
        HttpServletRequest request = WebmvcRequestContextHolder.getRequest();
        return request != null ? WebmvcRequestContextHolder.parseRequestUri(request) : null;
    }

    @Nullable
    public Integer getResponseStatusCode() {
        HttpServletRequest request = WebmvcRequestContextHolder.getRequest();
        if (request == null) {
            return null;
        }
        Object errorStatusCode = request.getAttribute("jakarta.servlet.error.status_code");
        return errorStatusCode instanceof Integer ? (Integer)errorStatusCode : null;
    }
}

