/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.web.webmvc.support;

import net.guerlab.cloud.commons.ip.IpUtils;
import net.guerlab.cloud.web.core.annotation.RequestIp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class WebMvcRequestIpHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(WebMvcRequestIpHandlerMethodArgumentResolver.class);

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterAnnotation(RequestIp.class) != null;
    }

    @Nullable
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        Object nativeRequest = webRequest.getNativeRequest();
        log.debug("nativeRequest: {}", nativeRequest);
        String ip = IpUtils.getIp((Object)nativeRequest);
        log.debug("get ip in nativeRequest: {}", (Object)ip);
        return ip;
    }
}

