/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sdk.wx.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.guerlab.sdk.wx.client.WeiXinClient;
import net.guerlab.sdk.wx.client.impl.DefaultWeiXinClient;
import net.guerlab.sdk.wx.config.WeiXinConfig;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WeiXinConfig.class})
public class WeiXinAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeiXinAutoConfiguration.class);
    @Autowired
    private WeiXinConfig config;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired(required=false)
    private OkHttpClient okHttpClient;

    @Bean(value={"DefaultWeiXinClient"})
    public WeiXinClient createDefaultWeiXinClient() {
        String appId = this.config.getAppid();
        String secret = this.config.getSecret();
        String payAppid = this.config.getPayAppid();
        String paySecret = this.config.getPaySecret();
        String payMchId = this.config.getPayMchId();
        String payKey = this.config.getPayKey();
        return new DefaultWeiXinClient(appId, secret, payAppid, paySecret, payMchId, payKey, this.getOkHttpClient(), this.objectMapper);
    }

    private OkHttpClient getOkHttpClient() {
        if (this.okHttpClient != null) {
            return this.okHttpClient;
        }
        return WeiXinAutoConfiguration.createHttpClient();
    }

    public static OkHttpClient createHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).sslSocketFactory(WeiXinAutoConfiguration.createSSLSocketFactory(), (X509TrustManager)new TrustAllManager()).hostnameVerifier((hostname, session) -> true).build();
    }

    private static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory sSLSocketFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllManager()}, new SecureRandom());
            sSLSocketFactory = sc.getSocketFactory();
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return sSLSocketFactory;
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

