package net.guerlab.sdk.yilianyun.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import net.guerlab.sdk.yilianyun.accesstoken.AccessTokenManager;
import net.guerlab.sdk.yilianyun.client.DefaultYiLianYunClient;
import net.guerlab.sdk.yilianyun.client.YiLianYunClient;

/**
 * 易联云自动配置
 * 
 * @author guer
 *
 */
@Configuration
@EnableConfigurationProperties(YiLianYunConfig.class)
public class YiLianYunAutoConfiguration {

    @Autowired
    private YiLianYunConfig config;

    /**
     * 创建默认蜂鸟请求客户端
     * 
     * @return 蜂鸟请求客户端
     */
    @Bean("DefaultYiLianYunClient")
    public YiLianYunClient createDefaultYiLianYunClient() {
        YiLianYunClient client = new DefaultYiLianYunClient(config.getClientId(), config.getClientSecret());

        AccessTokenManager.instance().setClient(client);

        return client;
    }

}
