/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.baiducloud;

import net.guerlab.sms.baiducloud.BaiduCloudProperties;
import net.guerlab.sms.baiducloud.BaiduCloudSendHandler;
import net.guerlab.sms.server.autoconfigure.SmsConfiguration;
import net.guerlab.sms.server.loadbalancer.SmsSenderLoadBalancer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@EnableConfigurationProperties(value={BaiduCloudProperties.class})
@AutoConfigureAfter(value={SmsConfiguration.class})
public class BaiduCloudAutoConfigure {
    @Bean
    @Conditional(value={BaiduCloudSendHandlerCondition.class})
    @ConditionalOnBean(value={SmsSenderLoadBalancer.class})
    public BaiduCloudSendHandler baiduCloudSendHandler(BaiduCloudProperties properties, SmsSenderLoadBalancer loadbalancer) {
        BaiduCloudSendHandler handler = new BaiduCloudSendHandler(properties);
        loadbalancer.addTarget((Object)handler, Boolean.valueOf(true));
        loadbalancer.setWeight((Object)handler, properties.getWeight());
        return handler;
    }

    public static class BaiduCloudSendHandlerCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Boolean enable = (Boolean)context.getEnvironment().getProperty("sms.baiducloud.enable", Boolean.class);
            return enable == null || enable != false;
        }
    }
}

