/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.baiducloud;

import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.sms.SmsClient;
import com.baidubce.services.sms.SmsClientConfiguration;
import com.baidubce.services.sms.model.SendMessageV3Request;
import com.baidubce.services.sms.model.SendMessageV3Response;
import java.util.Collection;
import net.guerlab.sms.baiducloud.BaiduCloudProperties;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.handler.SendHandler;
import net.guerlab.sms.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduCloudSendHandler
implements SendHandler {
    private static final Logger log = LoggerFactory.getLogger(BaiduCloudSendHandler.class);
    private final BaiduCloudProperties properties;
    private final SmsClient client;

    public BaiduCloudSendHandler(BaiduCloudProperties properties) {
        this.properties = properties;
        SmsClientConfiguration config = new SmsClientConfiguration();
        config.setCredentials((BceCredentials)new DefaultBceCredentials(properties.getAccessKeyId(), properties.getSecretAccessKey()));
        config.setEndpoint(properties.getEndpoint());
        this.client = new SmsClient(config);
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        String templateId = (String)this.properties.getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            return false;
        }
        SendMessageV3Request request = new SendMessageV3Request();
        request.setMobile(StringUtils.join(phones, (String)","));
        request.setSignatureId(this.properties.getSignatureId());
        request.setTemplate(templateId);
        request.setContentVar(noticeData.getParams());
        SendMessageV3Response response = this.client.sendMessage(request);
        if (response == null) {
            log.debug("send fail: not response");
            return false;
        }
        if (!response.isSuccess()) {
            log.debug("send fail: {}", (Object)response.getCode());
            return false;
        }
        return true;
    }
}

