/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.amazon;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.S3Object;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.ideahut.springboot.amazon.AmazonS3Handler;
import net.ideahut.springboot.amazon.AmazonS3Properties;
import net.ideahut.springboot.util.BeanUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AmazonS3HandlerImpl
implements AmazonS3Handler,
InitializingBean {
    private AmazonS3 client;
    private AmazonS3Properties properties;

    public AmazonS3HandlerImpl setProperties(AmazonS3Properties properties) {
        this.properties = properties;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.properties, (String)"properties is required");
        Assert.hasLength((String)this.properties.getAccessKey(), (String)"accessKey is required");
        Assert.hasLength((String)this.properties.getSecretKey(), (String)"secretKey is required");
        Assert.hasLength((String)this.properties.getRegion(), (String)"region is required");
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.properties.getAccessKey(), this.properties.getSecretKey());
        this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(Regions.fromName((String)this.properties.getRegion()))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).build();
    }

    @Override
    public boolean isBucketExist(String bucketName) {
        return this.client.doesBucketExistV2(bucketName);
    }

    @Override
    public String getBucketLocation(String bucketName) {
        return this.client.getBucketLocation(bucketName);
    }

    @Override
    public Bucket createBucket(String bucketName) {
        CreateBucketRequest request = new CreateBucketRequest(bucketName, Region.fromValue((String)this.properties.getRegion()));
        return this.client.createBucket(request);
    }

    @Override
    public void deleteBucket(String bucketName) {
        this.client.deleteBucket(bucketName);
    }

    @Override
    public boolean isObjectExist(String bucketName, String objectName) {
        return this.client.doesObjectExist(bucketName, objectName);
    }

    @Override
    public List<Bucket> listBuckets() {
        return this.client.listBuckets();
    }

    @Override
    public ObjectListing listObjects(String bucketName) {
        return this.client.listObjects(bucketName);
    }

    @Override
    public ObjectListing listObjects(String bucketName, String prefix) {
        return this.client.listObjects(bucketName, prefix);
    }

    @Override
    public S3Object getObject(String bucketName, String key) {
        return this.client.getObject(bucketName, key);
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        return this.client.copyObject(sourceBucketName, sourceKey, destinationBucketName, destinationKey);
    }

    @Override
    public void deleteObject(String bucketName, String key) {
        this.client.deleteObject(bucketName, key);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, InputStream input, String contentType) {
        ObjectMetadata metadata = new ObjectMetadata();
        if (contentType != null) {
            metadata.setContentType(contentType);
        }
        if (input != null) {
            try {
                metadata.setContentLength((long)input.available());
            }
            catch (IOException e) {
                throw BeanUtil.exception(e);
            }
        }
        return this.client.putObject(new PutObjectRequest(bucketName, key, input, metadata).withCannedAcl(CannedAccessControlList.PublicRead));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, byte[] input, String contentType) {
        return this.putObject(bucketName, key, new ByteArrayInputStream(input), contentType);
    }
}

