/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.audit;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.ideahut.springboot.audit.AuditRequest;
import net.ideahut.springboot.audit.DatabaseAuditProperties;
import net.ideahut.springboot.converter.EntityConverter;
import net.ideahut.springboot.crud.CrudHelper;
import net.ideahut.springboot.entity.EntityFilter;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.exception.RethrowException;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.util.BeanUtil;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ByteArrayJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.LongJavaType;
import org.hibernate.type.descriptor.java.StringJavaType;
import org.hibernate.type.descriptor.jdbc.BigIntJdbcType;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.LongVarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class AuditHelper {
    private static final Field typeField;
    private static final DataMapper mapper;
    private static final BasicType<String> stringType;
    private static final BasicType<Long> longType;
    private static final BasicType<String> textType;
    private static final BasicType<Byte[]> bytesType;

    private AuditHelper() {
    }

    public static DataMapper getMapper() {
        return mapper;
    }

    public static Column createColumn(MetadataBuildingContext metadataBuildingContext, Table table, Class<? extends Serializable> otype, BasicType<?> htype, String name, Integer length, boolean nullable, Integer scale, boolean unique, Integer precision) throws CommonException {
        try {
            AuditSimpleValue value = new AuditSimpleValue(metadataBuildingContext, table);
            value.setTypeName(otype.getName());
            typeField.set((Object)value, htype);
            Column column = new Column();
            column.setName(name);
            if (length != null && length > 0) {
                column.setLength(length);
            }
            if (scale != null && scale > 0) {
                column.setScale(scale);
            }
            if (precision != null && precision > 0) {
                column.setPrecision(precision);
            }
            column.setValue((Value)value);
            column.setTypeIndex(0);
            column.setNullable(nullable);
            column.setUnique(unique);
            return column;
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    public static Column createColumn(MetadataBuildingContext metadataBuildingContext, Table table, Class<? extends Serializable> otype, BasicType<?> htype, String name) throws CommonException {
        return AuditHelper.createColumn(metadataBuildingContext, table, otype, htype, name, 255, false, 2, false, 19);
    }

    public static Column createColumn(MetadataBuildingContext metadataBuildingContext, Table table, Class<? extends Serializable> otype, BasicType<?> htype, String name, Integer length, boolean nullable) throws CommonException {
        return AuditHelper.createColumn(metadataBuildingContext, table, otype, htype, name, length, nullable, 2, false, 19);
    }

    public static Column createColumn(MetadataBuildingContext metadataBuildingContext, Table table, Class<? extends Serializable> otype, BasicType<?> htype, String name, boolean nullable) throws CommonException {
        return AuditHelper.createColumn(metadataBuildingContext, table, otype, htype, name, 255, nullable, 2, false, 19);
    }

    public static int addAuditColumn(EntityIntegrator integrator, Table table, AColumn tcolumn, StringBuilder sqlInsert, StringBuilder sqlSelect, Collection<String> selectFields, List<ATableFieldInfo> fields) throws CommonException {
        try {
            Dialect dialect = integrator.getSessionFactory().getJdbcServices().getDialect();
            Column action = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, String.class, stringType, tcolumn.getAction(), 100, false);
            table.addColumn(action);
            selectFields.add(action.getName());
            sqlInsert.append(action.getQuotedName(dialect)).append(",");
            sqlSelect.append(action.getQuotedName(dialect)).append(",");
            fields.add(new ATableFieldInfo(action));
            Column actor = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, String.class, stringType, tcolumn.getActor(), 255, true);
            table.addColumn(actor);
            selectFields.add(actor.getName());
            sqlInsert.append(actor.getQuotedName(dialect)).append(",");
            sqlSelect.append(actor.getQuotedName(dialect)).append(",");
            fields.add(new ATableFieldInfo(actor));
            Column info = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, String.class, textType, tcolumn.getInfo(), true);
            table.addColumn(info);
            selectFields.add(info.getName());
            sqlInsert.append(info.getQuotedName(dialect)).append(",");
            sqlSelect.append(info.getQuotedName(dialect)).append(",");
            fields.add(new ATableFieldInfo(info));
            Column entry = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, Long.class, longType, tcolumn.getEntry());
            table.addColumn(entry);
            selectFields.add(entry.getName());
            sqlInsert.append(entry.getQuotedName(dialect)).append(",");
            sqlSelect.append(entry.getQuotedName(dialect)).append(",");
            fields.add(new ATableFieldInfo(entry));
            return 4;
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    public static Table createAuditTable(EntityIntegrator integrator, final Namespace namespace, Identifier identifier) throws CommonException {
        Table table = namespace.createTable(identifier, (Function)new Function<Identifier, Table>(){

            @Override
            public Table apply(Identifier physicalTableName) {
                return new Table("orm", namespace, physicalTableName, false);
            }
        });
        Column id = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, String.class, stringType, "id", 128, false);
        table.addColumn(id);
        Column type = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, String.class, stringType, "type", 512, false);
        table.addColumn(type);
        Column action = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, String.class, stringType, "action", 128, false);
        table.addColumn(action);
        Column actor = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, String.class, stringType, "actor", 512, true);
        table.addColumn(actor);
        Column info = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, String.class, textType, "info", true);
        table.addColumn(info);
        Column content = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, String.class, textType, "content", true);
        table.addColumn(content);
        Column bytes = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, byte[].class, bytesType, "bytes", true);
        table.addColumn(bytes);
        Column entry = AuditHelper.createColumn(integrator.getMetadataBuildingContext(), table, Long.class, longType, "entry", false);
        table.addColumn(entry);
        PrimaryKey primaryKey = new PrimaryKey(table);
        primaryKey.addColumn(id);
        return table;
    }

    public static Table copyTable(EntityIntegrator integrator, Table table, ATable ttable, AEnable ttenable) {
        Database database = integrator.getMetadata().getDatabase();
        Namespace namespace = database.getDefaultNamespace();
        Namespace.Name name = namespace.getName();
        Identifier schema = name != null ? name.getSchema() : null;
        Identifier catalog = name != null ? name.getCatalog() : null;
        Table newTable = new Table("orm");
        newTable.setName(ttable.getPrefix() + table.getName() + ttable.getSuffix());
        if (schema != null) {
            newTable.setSchema(schema.render());
        }
        if (catalog != null) {
            newTable.setCatalog(catalog.render());
        }
        newTable.setComment(table.getComment());
        newTable.setAbstract(table.isAbstract());
        newTable.setQuoted(table.isQuoted());
        if (ttenable.isRowid()) {
            newTable.setRowId(table.getRowId());
        } else {
            newTable.setRowId(null);
        }
        return newTable;
    }

    public static AuditRequest getAuditRequest(byte[] data) throws CommonException {
        try {
            String type;
            AuditRequest request = new AuditRequest();
            JsonNode node = mapper.read(data, JsonNode.class);
            String manager = node.has("manager") ? node.get("manager").asText().trim() : "";
            request.setManager(manager);
            String entity = node.has("entity") ? node.get("entity").asText().trim() : "";
            request.setEntity(entity);
            String string = type = node.has("type") ? node.get("type").asText().trim() : "";
            if (!type.isEmpty()) {
                request.setType(Class.forName(type));
            }
            if (node.has("page")) {
                Page page = mapper.convert((Object)node.get("page"), Page.class);
                request.setPage(page);
            }
            if (node.has("filter")) {
                request.setFilter(CrudHelper.nodeToFilter(node.get("filter")));
            }
            if (node.has("order")) {
                ArrayList<String> order = new ArrayList<String>();
                for (JsonNode item : node.get("order")) {
                    order.add(item.asText().trim());
                }
                request.setOrder(order);
            }
            request.setIgnoreBytes(node.has("ignoreBytes") ? node.get("ignoreBytes").asBoolean() : Boolean.TRUE.booleanValue());
            return request;
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    public static EntityHelper.Where where(TableAccessible tableAccessible, AColumn acolumn, AuditRequest auditRequest, boolean isAnonymous) {
        StringBuilder sql = new StringBuilder("where 1=1 ");
        ArrayList<Object> params = new ArrayList<Object>();
        List<EntityFilter> filters = auditRequest.getFilter();
        if (filters != null && !filters.isEmpty()) {
            for (EntityFilter filter : filters) {
                AuditHelper.prepareFilter(tableAccessible, filter, sql, params, acolumn, isAnonymous);
            }
        }
        EntityHelper.Where where = new EntityHelper.Where();
        where.setQuery(sql.toString());
        where.setParameters(params);
        return where;
    }

    private static void prepareFilter(TableAccessible tableAccessible, EntityFilter filter, StringBuilder sql, List<Object> params, AColumn acolumn, boolean isAnonymous) {
        if (filter.getField() == null) {
            throw new RethrowException("Filter field is required");
        }
        String column = filter.getField();
        EntityInfo entityInfo = tableAccessible.getEntityInfo();
        FieldInfo fieldInfo = null;
        if (entityInfo != null) {
            IdInfo idInfo = entityInfo.getIdInfo();
            if (EntityIdType.EMBEDDED == idInfo.getIdType()) {
                FieldInfo fiId = idInfo.getEmbeddedEntityInfo().getFieldInfo(filter.getField());
                if (fiId != null) {
                    column = fiId.getColumn();
                } else {
                    fieldInfo = entityInfo.getFieldInfo(filter.getField());
                    if (fieldInfo != null) {
                        column = fieldInfo.getColumn();
                    } else {
                        fieldInfo = entityInfo.getColumnInfo(filter.getField());
                        if (fieldInfo != null) {
                            column = fieldInfo.getColumn();
                        }
                    }
                }
            } else {
                fieldInfo = entityInfo.getFieldInfo(filter.getField());
                if (fieldInfo != null) {
                    column = fieldInfo.getColumn();
                } else {
                    fieldInfo = entityInfo.getColumnInfo(filter.getField());
                    if (fieldInfo != null) {
                        column = fieldInfo.getColumn();
                    }
                }
            }
        } else if (!isAnonymous && acolumn != null && !acolumn.isExist(column)) {
            throw BeanUtil.exception("Invalid filter field: " + column);
        }
        String logic = " " + filter.getLogical().name();
        EntityFilter.Condition condition = filter.getCondition();
        ArrayList<Object> lvals = new ArrayList<Object>();
        if (condition.isConvert()) {
            for (String svalue : filter.getValue()) {
                Object ovalue = AuditHelper.getFieldValue(fieldInfo, filter.getField(), acolumn, svalue);
                lvals.add(ovalue);
            }
        } else {
            for (String svalue : filter.getValue()) {
                lvals.add(svalue);
            }
        }
        EntityFilter.QueryAndParams queryAndParams = condition.getQueryAndParamsGetter().getQueryAndParams(logic, params.size(), column, lvals.toArray());
        sql.append(queryAndParams.getQuery());
        params.addAll(queryAndParams.getParams());
    }

    private static Object getFieldValue(FieldInfo fieldInfo, String anyFieldName, AColumn acolumn, String value) {
        return AuditHelper.getFieldValue(fieldInfo, anyFieldName, acolumn, Arrays.asList(value));
    }

    private static Object getFieldValue(FieldInfo fieldInfo, String anyFieldName, AColumn acolumn, Collection<String> value) {
        Object result = null;
        if (value != null && !value.isEmpty()) {
            try {
                if (fieldInfo != null) {
                    if (fieldInfo.getConverter() instanceof EntityConverter) {
                        Object evalue = EntityHelper.getFieldValue(fieldInfo.getEntityInfo(), anyFieldName, value);
                        EntityInfo entityInfo = fieldInfo.getEntityInfo().getTrxManagerInfo().getEntityInfo(fieldInfo.getType());
                        if (entityInfo != null) {
                            result = entityInfo.getFieldInfo(entityInfo.getIdInfo().getFields().iterator().next()).getValue(evalue);
                        }
                    } else {
                        result = fieldInfo.getConverter().convert(value);
                    }
                } else {
                    result = acolumn != null && acolumn.isEntry(anyFieldName) ? Long.valueOf(value.iterator().next()) : value.iterator().next();
                }
            }
            catch (Exception e) {
                throw BeanUtil.exception(e);
            }
        }
        return result;
    }

    public static String orderBy(TableAccessible tableAccessible, AuditRequest auditRequest) {
        StringBuilder orderBy = new StringBuilder();
        List<String> orders = auditRequest.getOrder();
        if (orders != null) {
            for (String order : orders) {
                EntityInfo entityInfo;
                boolean isAsc;
                String column = order != null ? order.trim() : "";
                if (column.isEmpty()) continue;
                boolean bl = isAsc = !column.startsWith("-");
                if (!isAsc) {
                    column = column.substring(1);
                }
                if ((entityInfo = tableAccessible.entityInfo) != null) {
                    FieldInfo fieldInfo = entityInfo.getFieldInfo(column);
                    if (fieldInfo != null) {
                        column = fieldInfo.getColumn();
                    } else {
                        fieldInfo = entityInfo.getColumnInfo(column);
                        if (fieldInfo != null) {
                            column = fieldInfo.getColumn();
                        }
                    }
                }
                orderBy.append(column).append(" ").append(isAsc ? "asc" : "desc").append(",");
            }
        }
        Object result = "";
        if (orderBy.length() > 1) {
            orderBy.deleteCharAt(orderBy.length() - 1);
            result = " order by " + orderBy.toString();
        }
        return result;
    }

    static {
        Field typeField0 = null;
        try {
            typeField0 = SimpleValue.class.getDeclaredField("type");
            typeField0.setAccessible(true);
        }
        catch (Exception e) {
            BeanUtil.nothing();
        }
        typeField = typeField0;
        mapper = new DataMapperImpl();
        stringType = new BasicTypeImpl((JavaType)StringJavaType.INSTANCE, (JdbcType)VarcharJdbcType.INSTANCE);
        longType = new BasicTypeImpl((JavaType)LongJavaType.INSTANCE, (JdbcType)BigIntJdbcType.INSTANCE);
        textType = new BasicTypeImpl((JavaType)StringJavaType.INSTANCE, (JdbcType)LongVarcharJdbcType.INSTANCE);
        bytesType = new BasicTypeImpl((JavaType)ByteArrayJavaType.INSTANCE, (JdbcType)BlobJdbcType.DEFAULT);
    }

    private static final class AuditSimpleValue
    extends SimpleValue {
        private MetadataBuildingContext buildingContext;
        private Table table;
        private SimpleValue original;

        public AuditSimpleValue(MetadataBuildingContext buildingContext) {
            super(buildingContext);
            this.buildingContext = buildingContext;
        }

        public AuditSimpleValue(MetadataBuildingContext buildingContext, Table table) {
            super(buildingContext, table);
            this.buildingContext = buildingContext;
            this.table = table;
        }

        public AuditSimpleValue(SimpleValue original) {
            super(original);
            this.original = original;
        }

        public Type getType() throws MappingException {
            try {
                return (Type)typeField.get((Object)this);
            }
            catch (Exception e) {
                throw new MappingException((Throwable)e);
            }
        }

        public Value copy() {
            AuditSimpleValue asv = null;
            asv = this.buildingContext != null ? (this.table != null ? new AuditSimpleValue(this.buildingContext, this.table) : new AuditSimpleValue(this.buildingContext)) : new AuditSimpleValue(this.original);
            return asv;
        }
    }

    public static class AColumn {
        private final String actor;
        private final String action;
        private final String info;
        private final String entry;

        AColumn(DatabaseAuditProperties properties) {
            DatabaseAuditProperties.Column column = properties.getColumn();
            column = column != null ? column : new DatabaseAuditProperties.Column();
            String actor0 = column.getActor();
            String string = actor0 = actor0 != null ? actor0.trim() : "";
            if (actor0.isEmpty()) {
                actor0 = "_actor_";
            }
            this.actor = actor0;
            String action0 = column.getAction();
            String string2 = action0 = action0 != null ? action0.trim() : "";
            if (action0.isEmpty()) {
                action0 = "_action_";
            }
            this.action = action0;
            String info0 = column.getInfo();
            String string3 = info0 = info0 != null ? info0.trim() : "";
            if (info0.isEmpty()) {
                info0 = "_info_";
            }
            this.info = info0;
            String entry0 = column.getEntry();
            String string4 = entry0 = entry0 != null ? entry0.trim() : "";
            if (entry0.isEmpty()) {
                entry0 = "_entry_";
            }
            this.entry = entry0;
        }

        public boolean isExist(String column) {
            boolean exist = false;
            if (column != null && (column.equals(this.actor) || column.equals(this.action) || column.equals(this.info) || column.equals(this.entry))) {
                exist = true;
            }
            return exist;
        }

        public boolean isEntry(String column) {
            return column != null && column.equals(this.entry);
        }

        public String getActor() {
            return this.actor;
        }

        public String getAction() {
            return this.action;
        }

        public String getInfo() {
            return this.info;
        }

        public String getEntry() {
            return this.entry;
        }
    }

    public static class ATableFieldInfo {
        private Column column;
        private FieldInfo fieldInfo;
        private FieldInfo childInfo;
        private String referencedColumnName;
        private EntityInfo referencedEntityInfo;

        public ATableFieldInfo() {
        }

        public ATableFieldInfo(Column column) {
            this.column = column;
        }

        public void setColumn(Column column) {
            this.column = column;
        }

        public void setFieldInfo(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
        }

        public void setChildInfo(FieldInfo childInfo) {
            this.childInfo = childInfo;
        }

        public void setReferencedColumnName(String referencedColumnName) {
            this.referencedColumnName = referencedColumnName;
        }

        public void setReferencedEntityInfo(EntityInfo referencedEntityInfo) {
            this.referencedEntityInfo = referencedEntityInfo;
        }

        public Column getColumn() {
            return this.column;
        }

        public FieldInfo getFieldInfo() {
            return this.fieldInfo;
        }

        public FieldInfo getChildInfo() {
            return this.childInfo;
        }

        public String getReferencedColumnName() {
            return this.referencedColumnName;
        }

        public EntityInfo getReferencedEntityInfo() {
            return this.referencedEntityInfo;
        }
    }

    public static class ATable {
        private final String prefix;
        private final String suffix;

        ATable(DatabaseAuditProperties properties) {
            String suffix0;
            DatabaseAuditProperties.Table table = properties.getTable();
            table = table != null ? table : new DatabaseAuditProperties.Table();
            String prefix0 = table.getPrefix();
            String string = prefix0 = prefix0 != null ? prefix0.trim() : "";
            if (prefix0.isEmpty()) {
                prefix0 = "__";
            }
            suffix0 = (suffix0 = table.getSuffix()) != null ? suffix0.trim() : "";
            this.prefix = prefix0;
            this.suffix = suffix0;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }

    public static class AEnable {
        private final boolean audit;
        private final boolean rowid;
        private final boolean index;
        private final boolean any;

        AEnable(DatabaseAuditProperties properties) {
            DatabaseAuditProperties.Enable enable = properties.getEnable();
            enable = enable != null ? enable : new DatabaseAuditProperties.Enable();
            this.audit = !Boolean.FALSE.equals(enable.getAudit());
            this.rowid = !Boolean.FALSE.equals(enable.getRowid());
            this.index = !Boolean.FALSE.equals(enable.getIndex());
            this.any = Boolean.TRUE.equals(enable.getAny());
        }

        public boolean isAudit() {
            return this.audit;
        }

        public boolean isRowid() {
            return this.rowid;
        }

        public boolean isIndex() {
            return this.index;
        }

        public boolean isAny() {
            return this.any;
        }
    }

    public static class TableAccessible {
        private Table table;
        private EntityInfo entityInfo;
        private String selectSql;
        private List<String> selectFields;
        private String insertSql;
        private List<ATableFieldInfo> insertParams = new ArrayList<ATableFieldInfo>();
        private List<ATableFieldInfo> fields = new ArrayList<ATableFieldInfo>();

        public void setTable(Table table) {
            this.table = table;
        }

        public void setEntityInfo(EntityInfo entityInfo) {
            this.entityInfo = entityInfo;
        }

        public void setSelectSql(String selectSql) {
            this.selectSql = selectSql;
        }

        public void setSelectFields(List<String> selectFields) {
            this.selectFields = selectFields;
        }

        public void setInsertSql(String insertSql) {
            this.insertSql = insertSql;
        }

        public void setInsertParams(List<ATableFieldInfo> insertParams) {
            this.insertParams = insertParams;
        }

        public void setFields(List<ATableFieldInfo> fields) {
            this.fields = fields;
        }

        public Table getTable() {
            return this.table;
        }

        public EntityInfo getEntityInfo() {
            return this.entityInfo;
        }

        public String getSelectSql() {
            return this.selectSql;
        }

        public List<String> getSelectFields() {
            return this.selectFields;
        }

        public String getInsertSql() {
            return this.insertSql;
        }

        public List<ATableFieldInfo> getInsertParams() {
            return this.insertParams;
        }

        public List<ATableFieldInfo> getFields() {
            return this.fields;
        }
    }

    public static class TrxManagerAccessible {
        private String auditIdentifier;
        private TrxManagerInfo trxManagerInfo;
        private EntityIntegrator auditIntegrator;
        private Map<Class<?>, TableAccessible> tableAccessibles = new HashMap();

        public void setAuditIdentifier(String auditIdentifier) {
            this.auditIdentifier = auditIdentifier;
        }

        public void setTrxManagerInfo(TrxManagerInfo trxManagerInfo) {
            this.trxManagerInfo = trxManagerInfo;
        }

        public void setAuditIntegrator(EntityIntegrator auditIntegrator) {
            this.auditIntegrator = auditIntegrator;
        }

        public void setTableAccessibles(Map<Class<?>, TableAccessible> tableAccessibles) {
            this.tableAccessibles = tableAccessibles;
        }

        public String getAuditIdentifier() {
            return this.auditIdentifier;
        }

        public TrxManagerInfo getTrxManagerInfo() {
            return this.trxManagerInfo;
        }

        public EntityIntegrator getAuditIntegrator() {
            return this.auditIntegrator;
        }

        public Map<Class<?>, TableAccessible> getTableAccessibles() {
            return this.tableAccessibles;
        }
    }

    public static class AWhere {
        private String query = "";
        private List<Object> parameters = new ArrayList<Object>();

        public void setQuery(String query) {
            this.query = query;
        }

        public void setParameters(List<Object> parameters) {
            this.parameters = parameters;
        }

        public String getQuery() {
            return this.query;
        }

        public List<Object> getParameters() {
            return this.parameters;
        }
    }

    public static class AGenerate {
        private final boolean table;
        private final int maxPrecision;
        private final int maxScale;

        AGenerate(DatabaseAuditProperties properties) {
            DatabaseAuditProperties.Generate generate = properties.getGenerate();
            generate = generate != null ? generate : new DatabaseAuditProperties.Generate();
            Integer maxPrecision0 = generate.getMaxPrecision();
            maxPrecision0 = maxPrecision0 != null && maxPrecision0 > 1 ? maxPrecision0 : 1000;
            Integer maxScale0 = generate.getMaxScale();
            maxScale0 = maxScale0 != null && maxScale0 > 0 ? maxScale0 : 2;
            Boolean table0 = generate.getTable();
            table0 = table0 != null ? table0 : Boolean.TRUE;
            this.maxPrecision = maxPrecision0;
            this.maxScale = maxScale0;
            this.table = table0;
        }

        public boolean isTable() {
            return this.table;
        }

        public int getMaxPrecision() {
            return this.maxPrecision;
        }

        public int getMaxScale() {
            return this.maxScale;
        }
    }

    public static final class AName {
        public static final String PREFIX = "__";
        public static final String ACTOR = "_actor_";
        public static final String ACTION = "_action_";
        public static final String INFO = "_info_";
        public static final String ENTRY = "_entry_";

        private AName() {
        }
    }
}

