/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.audit;

import java.io.Serializable;
import net.ideahut.springboot.context.RequestContext;

public class AuditInfo
implements Serializable {
    private static final long serialVersionUID = 7282772610580939787L;
    private static final String CONTEXT = AuditInfo.class.getName() + "_CONTEXT";
    private String actor;
    private String info;
    private String type;
    private Boolean skip;
    private String id;

    public AuditInfo() {
    }

    public AuditInfo(String actor) {
        this(actor, null);
    }

    public AuditInfo(String actor, String info) {
        this.actor = actor;
        this.info = info;
    }

    public AuditInfo setActor(String actor) {
        this.actor = actor;
        return this;
    }

    public AuditInfo setInfo(String info) {
        this.info = info;
        return this;
    }

    public AuditInfo setType(String type) {
        this.type = type;
        return this;
    }

    public AuditInfo setSkip(Boolean skip) {
        this.skip = skip;
        return this;
    }

    public AuditInfo setId(String id) {
        this.id = id;
        return this;
    }

    public static AuditInfo context() {
        AuditInfo auditInfo = (AuditInfo)RequestContext.currentContext().getAttribute(CONTEXT);
        if (auditInfo == null) {
            auditInfo = new AuditInfo();
            RequestContext.currentContext().setAttribute(CONTEXT, auditInfo);
        }
        return auditInfo;
    }

    public String getActor() {
        return this.actor;
    }

    public String getInfo() {
        return this.info;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getSkip() {
        return this.skip;
    }

    public String getId() {
        return this.id;
    }
}

