/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.audit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.audit.AuditHandler;
import net.ideahut.springboot.audit.AuditHelper;
import net.ideahut.springboot.audit.AuditInfo;
import net.ideahut.springboot.audit.AuditRequest;
import net.ideahut.springboot.audit.DatabaseAuditProperties;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.converter.EntityConverter;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.generator.StringIdGenerator;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.util.BeanUtil;
import net.ideahut.springboot.util.TimeUtil;
import org.hibernate.Session;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.query.NativeQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DatabaseMultiAuditHandler
implements AuditHandler,
InitializingBean,
BeanUtil.BeanConfigure<AuditHandler> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseMultiAuditHandler.class);
    private final Map<String, AuditHelper.TrxManagerAccessible> trxManagerAccessibles = new HashMap<String, AuditHelper.TrxManagerAccessible>();
    private boolean reconfigured = false;
    private AuditHelper.AEnable tenable;
    private AuditHelper.AColumn tcolumn;
    private EntityTrxManager entityTrxManager;
    private TaskHandler taskHandler;
    private DatabaseAuditProperties properties;
    private DataMapper dataMapper;

    public DatabaseMultiAuditHandler setEntityTrxManager(EntityTrxManager entityTrxManager) {
        this.entityTrxManager = entityTrxManager;
        return this;
    }

    public DatabaseMultiAuditHandler setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
        return this;
    }

    public DatabaseMultiAuditHandler setProperties(DatabaseAuditProperties properties) {
        this.properties = properties;
        return this;
    }

    public DatabaseMultiAuditHandler setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.entityTrxManager, (String)"entityTrxManager is required");
        Assert.notNull((Object)this.taskHandler, (String)"taskHandler is required");
        if (this.properties == null) {
            this.properties = new DatabaseAuditProperties();
        }
        if (this.dataMapper == null) {
            this.dataMapper = AuditHelper.getMapper();
        }
        this.tenable = new AuditHelper.AEnable(this.properties);
    }

    @Override
    public Callable<AuditHandler> reconfigureBean(Collection<Object> arguments) {
        final DatabaseMultiAuditHandler self = this;
        return new Callable<AuditHandler>(){

            @Override
            public AuditHandler call() throws Exception {
                if (DatabaseMultiAuditHandler.this.tenable == null) {
                    self.afterPropertiesSet();
                }
                if (DatabaseMultiAuditHandler.this.tenable != null && DatabaseMultiAuditHandler.this.tenable.isAudit()) {
                    DatabaseMultiAuditHandler.this.reconfigure();
                }
                DatabaseMultiAuditHandler.this.reconfigured = true;
                return self;
            }
        };
    }

    private void reconfigure() throws CommonException {
        this.tcolumn = new AuditHelper.AColumn(this.properties);
        AuditHelper.ATable ttable = new AuditHelper.ATable(this.properties);
        AuditHelper.AGenerate tgenerate = new AuditHelper.AGenerate(this.properties);
        for (TrxManagerInfo trxManagerInfo : this.entityTrxManager.getTrxManagerInfos()) {
            EntityIntegrator auditIntegrator;
            EntityIntegrator trxIntegrator = trxManagerInfo.getIntegrator();
            String auditIdentifier = trxIntegrator.getSessionFactory().getProperties().getOrDefault("hibernate.audit_identifier", "");
            if (auditIdentifier.isEmpty()) continue;
            AuditHelper.TrxManagerAccessible trxManagerAccessible = this.trxManagerAccessibles.getOrDefault(auditIdentifier, null);
            Assert.isNull((Object)trxManagerAccessible, (String)("Duplicate trxManagerAccessible for session factory audit id: " + auditIdentifier));
            SessionFactoryImplementor externalAuditSessionFactory = trxIntegrator.getSessionFactory().getProperties().getOrDefault("hibernate.audit_session_factory", null);
            if (externalAuditSessionFactory != null) {
                if (externalAuditSessionFactory.getProperties().get("hibernate.hbm2ddl.auto") != null) {
                    externalAuditSessionFactory.getProperties().put("hibernate.hbm2ddl.auto", "none");
                }
                auditIntegrator = EntityIntegrator.of(externalAuditSessionFactory.getProperties(), trxIntegrator.getAnnotatedClasses());
            } else {
                auditIntegrator = EntityIntegrator.of(trxIntegrator.getSessionFactory().getProperties());
            }
            Dialect auditDialect = auditIntegrator.getSessionFactory().getJdbcServices().getDialect();
            trxManagerAccessible = new AuditHelper.TrxManagerAccessible();
            trxManagerAccessible.setAuditIntegrator(auditIntegrator);
            trxManagerAccessible.setTableAccessibles(new HashMap());
            trxManagerAccessible.setTrxManagerInfo(trxManagerInfo);
            Database database = trxIntegrator.getMetadata().getDatabase();
            Namespace namespace = database.getDefaultNamespace();
            for (Table table : namespace.getTables()) {
                EntityInfo entityInfo = trxManagerInfo.getEntityInfo(table.getSchema(), table.getName());
                Audit annotAudit = entityInfo != null ? entityInfo.getAnnotation(Audit.class) : null;
                if (annotAudit == null || !annotAudit.value()) continue;
                IdInfo idInfo = entityInfo.getIdInfo();
                Table newTable = AuditHelper.copyTable(auditIntegrator, table, ttable, this.tenable);
                ArrayList<AuditHelper.ATableFieldInfo> fields = new ArrayList<AuditHelper.ATableFieldInfo>();
                ArrayList<AuditHelper.ATableFieldInfo> insertParams = new ArrayList<AuditHelper.ATableFieldInfo>();
                StringBuilder selectSql = new StringBuilder();
                ArrayList<String> selectFields = new ArrayList<String>();
                StringBuilder insertSql = new StringBuilder("insert into ").append(newTable.getQualifiedTableName()).append("(");
                Iterator iterator = table.getColumns().iterator();
                int countparam = 0;
                HashSet<String> proceedColumns = new HashSet<String>();
                while (iterator.hasNext()) {
                    Audit fieldAuditAnnot;
                    JoinColumns jColumns;
                    Column column = (Column)iterator.next();
                    if (proceedColumns.contains(column.getName())) continue;
                    AuditHelper.ATableFieldInfo tableFieldInfo = new AuditHelper.ATableFieldInfo();
                    if (EntityIdType.EMBEDDED == idInfo.getIdType()) {
                        fieldInfo = idInfo.getEmbeddedEntityInfo().getColumnInfo(column.getName());
                        if (fieldInfo == null) {
                            fieldInfo = idInfo.getEmbeddedEntityInfo().getColumnInfo(column.getName().toLowerCase());
                        }
                        tableFieldInfo.setChildInfo((FieldInfo)fieldInfo);
                        if (tableFieldInfo.getChildInfo() != null) {
                            tableFieldInfo.setFieldInfo(entityInfo.getFieldInfo(idInfo.getFields().iterator().next()));
                            this.createIdIndex(newTable, column);
                        }
                    } else if (EntityIdType.COMPOSITE == idInfo.getIdType()) {
                        for (String string : idInfo.getFields()) {
                            FieldInfo fieldInfo = entityInfo.getFieldInfo(string);
                            if (!fieldInfo.getColumn().equals(column.getName()) && !fieldInfo.getColumn().equals(column.getName().toLowerCase())) continue;
                            tableFieldInfo.setFieldInfo(fieldInfo);
                            this.createIdIndex(newTable, column);
                            break;
                        }
                    } else {
                        fieldInfo = entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
                        if (((FieldInfo)fieldInfo).getColumn().equals(column.getName()) || ((FieldInfo)fieldInfo).getColumn().equals(column.getName().toLowerCase())) {
                            this.createIdIndex(newTable, column);
                        }
                    }
                    if (tableFieldInfo.getFieldInfo() == null) {
                        tableFieldInfo.setFieldInfo(entityInfo.getColumnInfo(column.getName()));
                    }
                    if (tableFieldInfo.getFieldInfo() != null && (jColumns = tableFieldInfo.getFieldInfo().getAnnotation(JoinColumns.class)) != null) {
                        for (JoinColumn jColumn : jColumns.value()) {
                            if (!column.getName().equals(jColumn.name())) continue;
                            tableFieldInfo.setReferencedColumnName(jColumn.referencedColumnName());
                            EntityInfo referencedEntityInfo = trxManagerInfo.getEntityInfo(tableFieldInfo.getFieldInfo().getType());
                            tableFieldInfo.setReferencedEntityInfo(referencedEntityInfo);
                            break;
                        }
                    }
                    Audit audit = fieldAuditAnnot = tableFieldInfo.getFieldInfo() != null ? tableFieldInfo.getFieldInfo().getAnnotation(Audit.class) : null;
                    if (fieldAuditAnnot != null && !fieldAuditAnnot.value()) continue;
                    Column column2 = column.clone();
                    if (column2.getPrecision() != null && column2.getPrecision() > tgenerate.getMaxPrecision()) {
                        column2.setPrecision(Integer.valueOf(tgenerate.getMaxPrecision()));
                    }
                    if (column2.getScale() != null && column2.getScale() > tgenerate.getMaxScale()) {
                        column2.setScale(Integer.valueOf(tgenerate.getMaxScale()));
                    }
                    column2.setUnique(false);
                    column2.setNullable(true);
                    newTable.addColumn(column2);
                    tableFieldInfo.setColumn(column2);
                    insertSql.append(column2.getQuotedName(auditDialect)).append(",");
                    insertParams.add(tableFieldInfo);
                    fields.add(tableFieldInfo);
                    selectSql.append(column2.getQuotedName(auditDialect)).append(",");
                    if (tableFieldInfo.getFieldInfo() != null) {
                        if (EntityIdType.EMBEDDED == idInfo.getIdType() && idInfo.getFields().contains(tableFieldInfo.getFieldInfo().getName())) {
                            selectFields.add(idInfo.getEmbeddedEntityInfo().getColumnInfo(column.getName()).getName());
                        } else {
                            selectFields.add(tableFieldInfo.getFieldInfo().getName());
                        }
                    } else {
                        selectFields.add(column2.getName());
                    }
                    proceedColumns.add(column.getName());
                    ++countparam;
                }
                countparam += AuditHelper.addAuditColumn(auditIntegrator, newTable, this.tcolumn, insertSql, selectSql, selectFields, fields);
                selectSql.delete(selectSql.length() - 1, selectSql.length());
                insertSql.delete(insertSql.length() - 1, insertSql.length()).append(") values (");
                for (int i = 0; i < countparam; ++i) {
                    insertSql.append("?,");
                }
                insertSql.delete(insertSql.length() - 1, insertSql.length()).append(")");
                if (this.tenable.isIndex()) {
                    for (Index index : table.getIndexes().values()) {
                        Index newIndex = new Index();
                        newIndex.setName(ttable.getPrefix() + index.getName() + ttable.getSuffix());
                        newIndex.setTable(newTable);
                        for (Column column : index.getColumns()) {
                            Column newColumn = column.clone();
                            newColumn.setUnique(false);
                            newIndex.addColumn((Selectable)newColumn);
                        }
                        newTable.addIndex(newIndex);
                    }
                }
                AuditHelper.TableAccessible tableAccessible = new AuditHelper.TableAccessible();
                tableAccessible.setTable(newTable);
                tableAccessible.setSelectSql(selectSql.toString());
                tableAccessible.setSelectFields(selectFields);
                tableAccessible.setInsertSql(insertSql.toString());
                tableAccessible.setInsertParams(insertParams);
                tableAccessible.setEntityInfo(entityInfo);
                tableAccessible.setFields(fields);
                trxManagerAccessible.getTableAccessibles().put(entityInfo.getEntityClass(), tableAccessible);
            }
            String name = (!ttable.getPrefix().isEmpty() ? ttable.getPrefix() : "_") + "_any_" + auditIdentifier + ttable.getSuffix();
            Identifier identifier = new Identifier(name, false);
            Table table = AuditHelper.createAuditTable(auditIntegrator, namespace, identifier);
            AuditHelper.TableAccessible tableAccessible = new AuditHelper.TableAccessible();
            tableAccessible.setTable(table);
            tableAccessible.setSelectSql("id,type,action,actor,info,content,entry,bytes");
            tableAccessible.setSelectFields(Arrays.asList("id", "type", "action", "actor", "info", "content", "entry", "bytes"));
            trxManagerAccessible.getTableAccessibles().put(Void.class, tableAccessible);
            this.trxManagerAccessibles.put(auditIdentifier, trxManagerAccessible);
        }
        if (tgenerate.isTable()) {
            for (Map.Entry entry : this.trxManagerAccessibles.entrySet()) {
                for (Map.Entry<Class<?>, AuditHelper.TableAccessible> table : ((AuditHelper.TrxManagerAccessible)entry.getValue()).getTableAccessibles().entrySet()) {
                    EntityHelper.createTable(((AuditHelper.TrxManagerAccessible)entry.getValue()).getAuditIntegrator(), table.getValue().getTable());
                }
            }
        }
    }

    @Override
    public boolean isBeanConfigured() {
        return this.reconfigured;
    }

    @Override
    public void saveAudit(String action, Object object) {
        if (this.tenable.isAudit()) {
            String auditId;
            if (object == null) {
                return;
            }
            BeanUtil.checkBeanConfigure(this);
            AuditInfo auditInfo = AuditInfo.context();
            if (Boolean.TRUE.equals(auditInfo.getSkip())) {
                log.debug("Skip audit {}", (Object)auditInfo);
                return;
            }
            String string = auditId = auditInfo.getId() != null ? auditInfo.getId() : "";
            if (auditId.isEmpty()) {
                SessionFactoryImpl requestSessionFactory = (SessionFactoryImpl)RequestContext.currentContext().getAttribute(EntityIntegrator.SESSION_FACTORY);
                String string2 = auditId = requestSessionFactory != null ? requestSessionFactory.getProperties().getOrDefault("hibernate.audit_identifier", "") : "";
                if (auditId.isEmpty()) {
                    return;
                }
            }
            String fAuditId = auditId;
            this.taskHandler.execute(() -> this.storeAudit(fAuditId, object, auditInfo, action));
        }
    }

    private void storeAudit(String auditId, Object object, AuditInfo auditInfo, String action) {
        AuditHelper.TrxManagerAccessible trxManagerAccessible = this.trxManagerAccessibles.get(auditId);
        if (trxManagerAccessible == null) {
            log.warn("TrxManagerAccessible is not found, for sessionFactory audit id: {}", (Object)auditId);
            return;
        }
        Dialect auditDialect = trxManagerAccessible.getAuditIntegrator().getSessionFactory().getJdbcServices().getDialect();
        AuditHelper.TableAccessible tableAccessible = trxManagerAccessible.getTableAccessibles().getOrDefault(object.getClass(), null);
        boolean isAnonymous = tableAccessible == null;
        SessionImplementor session = null;
        try {
            if (!isAnonymous) {
                StringBuilder insertSql = new StringBuilder("insert into ").append(tableAccessible.getTable().getQualifiedTableName()).append("(");
                ArrayList<Object> parameters = new ArrayList<Object>();
                for (int i = 0; i < tableAccessible.getInsertParams().size(); ++i) {
                    Object value;
                    EntityInfo parentInfo;
                    AuditHelper.ATableFieldInfo tableFieldInfo = tableAccessible.getInsertParams().get(i);
                    FieldInfo fieldInfo = tableFieldInfo.getFieldInfo();
                    EntityInfo entityInfo = fieldInfo.getEntityInfo();
                    EntityInfo entityInfo2 = parentInfo = entityInfo != null ? entityInfo.getParentInfo() : null;
                    if (parentInfo != null) {
                        Object idvalue = parentInfo.getFieldInfo(parentInfo.getIdInfo().getFields().iterator().next()).getValue(object);
                        value = fieldInfo.getValue(idvalue);
                    } else {
                        value = fieldInfo.getValue(object);
                    }
                    if (value == null) continue;
                    if (tableFieldInfo.getChildInfo() != null) {
                        value = tableFieldInfo.getChildInfo().getValue(value);
                    } else if (tableFieldInfo.getReferencedEntityInfo() != null) {
                        FieldInfo efInfo;
                        EntityInfo eiRef = tableFieldInfo.getReferencedEntityInfo();
                        IdInfo idRef = eiRef.getIdInfo();
                        if (EntityIdType.EMBEDDED == idRef.getIdType()) {
                            Object id = eiRef.getFieldInfo(idRef.getFields().iterator().next()).getValue(value);
                            value = idRef.getEmbeddedEntityInfo().getColumnInfo(tableFieldInfo.getReferencedColumnName()).getValue(id);
                        } else {
                            value = eiRef.getFieldInfo(tableFieldInfo.getReferencedColumnName()).getValue(value);
                        }
                        EntityInfo ecInfo = entityInfo.getTrxManagerInfo().getEntityInfo(value.getClass());
                        if (ecInfo != null && (efInfo = ecInfo.getColumnInfo(tableFieldInfo.getReferencedColumnName())) != null) {
                            value = efInfo.getValue(value);
                        }
                    } else if (fieldInfo.getConverter() instanceof EntityConverter) {
                        EntityInfo valEntityInfo = trxManagerAccessible.getTrxManagerInfo().getEntityInfo(fieldInfo.getType());
                        value = valEntityInfo != null ? valEntityInfo.getFieldInfo(valEntityInfo.getIdInfo().getFields().iterator().next()).getValue(value) : null;
                    } else {
                        BeanUtil.nothing();
                    }
                    if (value == null) continue;
                    insertSql.append(tableFieldInfo.getColumn().getQuotedName(auditDialect)).append(",");
                    parameters.add(value);
                }
                int fsize = tableAccessible.getFields().size();
                if (action != null) {
                    insertSql.append(tableAccessible.getFields().get(fsize - 4).getColumn().getQuotedName(auditDialect)).append(",");
                    parameters.add(action);
                }
                if (auditInfo != null) {
                    if (auditInfo.getActor() != null) {
                        insertSql.append(tableAccessible.getFields().get(fsize - 3).getColumn().getQuotedName(auditDialect)).append(",");
                        parameters.add(auditInfo.getActor());
                    }
                    if (auditInfo.getInfo() != null) {
                        insertSql.append(tableAccessible.getFields().get(fsize - 2).getColumn().getQuotedName(auditDialect)).append(",");
                        parameters.add(auditInfo.getInfo());
                    }
                }
                insertSql.append(tableAccessible.getFields().get(fsize - 1).getColumn().getQuotedName(auditDialect)).append(",");
                parameters.add(TimeUtil.currentEpochMillis());
                insertSql.delete(insertSql.length() - 1, insertSql.length()).append(") values (");
                for (int i = 0; i < parameters.size(); ++i) {
                    insertSql.append("?,");
                }
                insertSql.delete(insertSql.length() - 1, insertSql.length()).append(")");
                session = trxManagerAccessible.getAuditIntegrator().getSessionFactory().openSession();
                session.beginTransaction();
                NativeQuery query = session.createNativeQuery(insertSql.toString());
                for (int i = 0; i < parameters.size(); ++i) {
                    query.setParameter(i + 1, parameters.get(i));
                }
                query.executeUpdate();
            } else {
                String theid = StringIdGenerator.createId("AUD");
                tableAccessible = trxManagerAccessible.getTableAccessibles().getOrDefault(Void.class, null);
                session = trxManagerAccessible.getAuditIntegrator().getSessionFactory().openSession();
                session.beginTransaction();
                NativeQuery query = session.createNativeQuery("insert into " + tableAccessible.getTable().getQualifiedTableName().render() + " (id, type, action, actor, info, content, bytes, entry) values (?,?,?,?,?,?,?,?)").setParameter(1, (Object)theid).setParameter(2, (Object)(auditInfo.getType() != null ? auditInfo.getType() : object.getClass().getName())).setParameter(3, (Object)(action != null ? action : "")).setParameter(4, (Object)auditInfo.getActor()).setParameter(5, (Object)auditInfo.getInfo());
                if (object instanceof byte[]) {
                    query.setParameter(6, null).setParameter(7, object);
                } else {
                    String content = this.dataMapper.writeAsString(object, 1);
                    query.setParameter(6, (Object)content).setParameter(7, null);
                }
                Long now = TimeUtil.currentEpochMillis();
                query.setParameter(8, (Object)now);
                query.executeUpdate();
            }
            EntityHelper.commit((Session)session);
        }
        catch (Exception e) {
            try {
                EntityHelper.rollback(session);
                throw BeanUtil.exception(e);
            }
            catch (Throwable throwable) {
                EntityHelper.close(session);
                throw throwable;
            }
        }
        EntityHelper.close((Session)session);
    }

    @Override
    public AuditRequest getAuditRequest(byte[] data) throws CommonException {
        return AuditHelper.getAuditRequest(data);
    }

    @Override
    public Page<JsonNode> getAuditList(AuditRequest auditRequest) {
        Page<Object> page = Page.empty();
        if (auditRequest != null) {
            SessionFactoryImplementor sessionFactory;
            String auditId;
            String manager = auditRequest.getManager();
            TrxManagerInfo trxManagerInfo = this.entityTrxManager.getTrxManagerInfo(manager);
            if (trxManagerInfo == null) {
                trxManagerInfo = this.entityTrxManager.getDefaultTrxManagerInfo();
            }
            if (!(auditId = (sessionFactory = trxManagerInfo.getIntegrator().getSessionFactory()).getProperties().getOrDefault("hibernate.audit_identifier", "")).isEmpty()) {
                SessionImplementor session;
                String orderBy;
                EntityHelper.Where where;
                boolean isAnonymous;
                AuditHelper.TableAccessible tableAccessible;
                block20: {
                    AuditHelper.TrxManagerAccessible trxManagerAccessible = this.trxManagerAccessibles.get(auditId);
                    Assert.notNull((Object)trxManagerAccessible, (String)("trxManagerAccessible is not found, for auditId: " + auditId));
                    tableAccessible = trxManagerAccessible.getTableAccessibles().get(auditRequest.getType());
                    isAnonymous = false;
                    if (tableAccessible == null) {
                        tableAccessible = trxManagerAccessible.getTableAccessibles().get(Void.class);
                        isAnonymous = true;
                    }
                    page = Page.of(1);
                    Page<?> inPage = auditRequest.getPage();
                    if (inPage != null) {
                        if (inPage.getIndex() != null && inPage.getIndex() > 0) {
                            page.setIndex(inPage.getIndex());
                        }
                        if (inPage.getSize() != null && inPage.getSize() > 0) {
                            page.setSize(inPage.getSize());
                        }
                        if (inPage.getCount() != null) {
                            page.setCount(inPage.getCount());
                        }
                    }
                    where = AuditHelper.where(tableAccessible, this.tcolumn, auditRequest, isAnonymous);
                    orderBy = AuditHelper.orderBy(tableAccessible, auditRequest);
                    session = null;
                    session = trxManagerAccessible.getAuditIntegrator().getSessionFactory().openSession();
                    if (!Boolean.TRUE.equals(page.getCount())) break block20;
                    NativeQuery query = session.createNativeQuery("select count(1) from " + tableAccessible.getTable().getQualifiedTableName() + " " + where.getQuery());
                    for (int i = 0; i < where.getParameters().size(); ++i) {
                        query.setParameter(i + 1, where.getParameters().get(i));
                    }
                    Long records = Long.valueOf("" + query.getSingleResult());
                    page.setRecords(records);
                    if (records != 0L) break block20;
                    Page<Object> page2 = page;
                    EntityHelper.close((Session)session);
                    return page2;
                }
                try {
                    boolean isIgnoreBytes = !Boolean.FALSE.equals(auditRequest.getIgnoreBytes());
                    String sql = tableAccessible.getSelectSql();
                    if (isAnonymous && isIgnoreBytes) {
                        sql = sql.substring(0, sql.lastIndexOf(","));
                    }
                    NativeQuery query = session.createNativeQuery("select " + sql + " from " + tableAccessible.getTable().getQualifiedTableName() + " " + where.getQuery() + " " + orderBy);
                    for (int i = 0; i < where.getParameters().size(); ++i) {
                        query.setParameter(i + 1, where.getParameters().get(i));
                    }
                    query.setFirstResult((page.getIndex() - 1) * page.getSize());
                    query.setMaxResults(page.getSize().intValue());
                    ArrayList<ObjectNode> data = new ArrayList<ObjectNode>();
                    int size = tableAccessible.getSelectFields().size();
                    if (isAnonymous && isIgnoreBytes) {
                        --size;
                    }
                    List items = query.getResultList();
                    while (!items.isEmpty()) {
                        Object[] item = (Object[])items.remove(0);
                        ArrayNode array = this.dataMapper.convert((Object)item, ArrayNode.class);
                        ObjectNode node = this.dataMapper.createObjectNode();
                        for (int i = 0; i < size; ++i) {
                            String fieldName = tableAccessible.getSelectFields().get(i);
                            JsonNode row = array.get(i);
                            if (isIgnoreBytes && row.isBinary()) continue;
                            if (row.isNull()) {
                                node.putNull(fieldName);
                                continue;
                            }
                            node.put(fieldName, row.asText());
                        }
                        data.add(node);
                    }
                    page.setData(data);
                }
                catch (Exception e) {
                    try {
                        throw BeanUtil.exception(e);
                    }
                    catch (Throwable throwable) {
                        EntityHelper.close(session);
                        throw throwable;
                    }
                }
                EntityHelper.close((Session)session);
            }
        }
        return page;
    }

    private void createIdIndex(Table table, Column column) {
        if (this.tenable.isIndex()) {
            Index index = new Index();
            index.setName("idx_" + table.getName() + "_" + column.getName());
            index.addColumn((Selectable)column);
            index.setTable(table);
            table.addIndex(index);
        }
    }
}

