/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.audit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.audit.AuditHandler;
import net.ideahut.springboot.audit.AuditHelper;
import net.ideahut.springboot.audit.AuditInfo;
import net.ideahut.springboot.audit.AuditRequest;
import net.ideahut.springboot.audit.DatabaseAuditProperties;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.generator.OdtIdGenerator;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.util.BeanUtil;
import net.ideahut.springboot.util.TimeUtil;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.mapping.Table;
import org.hibernate.query.NativeQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DatabaseSingleAuditHandler
implements AuditHandler,
InitializingBean,
BeanUtil.BeanConfigure<AuditHandler> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSingleAuditHandler.class);
    private final Map<String, AuditHelper.TrxManagerAccessible> trxManagerAccessibles = new HashMap<String, AuditHelper.TrxManagerAccessible>();
    private boolean reconfigured = false;
    private AuditHelper.AEnable tenable;
    private AuditHelper.ATable ttable;
    private AuditHelper.AGenerate tgenerate;
    private EntityTrxManager entityTrxManager;
    private TaskHandler taskHandler;
    private DataMapper dataMapper;
    private SessionFactory auditSessionFactory;
    private Boolean onlyOneDatabase = Boolean.FALSE;
    private DatabaseAuditProperties properties;

    public DatabaseSingleAuditHandler setEntityTrxManager(EntityTrxManager entityTrxManager) {
        this.entityTrxManager = entityTrxManager;
        return this;
    }

    public DatabaseSingleAuditHandler setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
        return this;
    }

    public DatabaseSingleAuditHandler setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public DatabaseSingleAuditHandler setAuditSessionFactory(SessionFactory auditSessionFactory) {
        this.auditSessionFactory = auditSessionFactory;
        return this;
    }

    public DatabaseSingleAuditHandler setOnlyOneDatabase(Boolean onlyOneDatabase) {
        this.onlyOneDatabase = onlyOneDatabase;
        return this;
    }

    public DatabaseSingleAuditHandler setProperties(DatabaseAuditProperties properties) {
        this.properties = properties;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.entityTrxManager, (String)"entityTrxManager is required");
        Assert.notNull((Object)this.taskHandler, (String)"taskHandler is required");
        if (this.dataMapper == null) {
            this.dataMapper = AuditHelper.getMapper();
        }
        if (this.properties == null) {
            this.properties = new DatabaseAuditProperties();
        }
        this.tenable = new AuditHelper.AEnable(this.properties);
    }

    @Override
    public Callable<AuditHandler> reconfigureBean(Collection<Object> arguments) {
        final DatabaseSingleAuditHandler self = this;
        return new Callable<AuditHandler>(){

            @Override
            public AuditHandler call() throws Exception {
                if (DatabaseSingleAuditHandler.this.tenable == null) {
                    self.afterPropertiesSet();
                }
                if (DatabaseSingleAuditHandler.this.tenable != null && DatabaseSingleAuditHandler.this.tenable.isAudit()) {
                    DatabaseSingleAuditHandler.this.reconfigure();
                }
                DatabaseSingleAuditHandler.this.reconfigured = true;
                return self;
            }
        };
    }

    private void reconfigure() throws CommonException {
        String auditIdentifier;
        this.ttable = new AuditHelper.ATable(this.properties);
        this.tgenerate = new AuditHelper.AGenerate(this.properties);
        for (TrxManagerInfo trxManagerInfo : this.entityTrxManager.getTrxManagerInfos()) {
            EntityIntegrator trxIntegrator = trxManagerInfo.getIntegrator();
            String auditIdentifier2 = trxIntegrator.getSessionFactory().getProperties().getOrDefault("hibernate.audit_identifier", "");
            if (auditIdentifier2.isEmpty()) continue;
            AuditHelper.TrxManagerAccessible trxManagerAccessible = this.trxManagerAccessibles.getOrDefault(auditIdentifier2, null);
            Assert.isNull((Object)trxManagerAccessible, (String)("Duplicate trxManagerAccessible for audit id: " + auditIdentifier2));
            trxManagerAccessible = new AuditHelper.TrxManagerAccessible();
            trxManagerAccessible.setAuditIdentifier(auditIdentifier2);
            trxManagerAccessible.setTableAccessibles(new HashMap());
            trxManagerAccessible.setTrxManagerInfo(trxManagerInfo);
            EntityIntegrator auditIntegrator = Boolean.TRUE.equals(this.onlyOneDatabase) && this.auditSessionFactory != null ? EntityIntegrator.of(this.auditSessionFactory.getProperties()) : EntityIntegrator.of(trxIntegrator.getSettings());
            AuditHelper.TableAccessible tableAccessible = this.createTableAccessible(auditIntegrator, auditIdentifier2);
            trxManagerAccessible.setAuditIntegrator(auditIntegrator);
            trxManagerAccessible.getTableAccessibles().put(Void.class, tableAccessible);
            this.trxManagerAccessibles.put(auditIdentifier2, trxManagerAccessible);
        }
        if (Boolean.TRUE.equals(this.onlyOneDatabase) && this.auditSessionFactory != null && this.trxManagerAccessibles.getOrDefault(auditIdentifier = this.auditSessionFactory.getProperties().getOrDefault("hibernate.audit_identifier", ""), null) == null) {
            EntityIntegrator auditIntegrator = EntityIntegrator.of(this.auditSessionFactory.getProperties());
            AuditHelper.TrxManagerAccessible trxManagerAccessible = new AuditHelper.TrxManagerAccessible();
            trxManagerAccessible.setAuditIdentifier(auditIdentifier);
            trxManagerAccessible.setTableAccessibles(new HashMap());
            trxManagerAccessible.setTrxManagerInfo(null);
            AuditHelper.TableAccessible tableAccessible = this.createTableAccessible(auditIntegrator, auditIdentifier);
            trxManagerAccessible.setAuditIntegrator(auditIntegrator);
            trxManagerAccessible.getTableAccessibles().put(Void.class, tableAccessible);
            this.trxManagerAccessibles.put(auditIdentifier, trxManagerAccessible);
        }
    }

    private AuditHelper.TableAccessible createTableAccessible(EntityIntegrator auditIntegrator, String auditIdentifier) throws CommonException {
        Identifier identifier;
        AuditHelper.TableAccessible tableAccessible = new AuditHelper.TableAccessible();
        String tblname = this.ttable.getPrefix() + auditIdentifier + this.ttable.getSuffix();
        Database database = auditIntegrator.getMetadata().getDatabase();
        Namespace namespace = database.getDefaultNamespace();
        if (namespace.locateTable(identifier = database.toIdentifier(tblname)) == null) {
            Table table = AuditHelper.createAuditTable(auditIntegrator, namespace, identifier);
            if (this.tgenerate.isTable()) {
                EntityHelper.createTable(auditIntegrator, table);
            }
            tableAccessible.setTable(table);
        } else {
            for (Table table : namespace.getTables()) {
                if (!table.getNameIdentifier().equals((Object)identifier)) continue;
                tableAccessible.setTable(table);
                break;
            }
        }
        tableAccessible.setSelectSql("id,type,action,actor,info,content,entry,bytes");
        tableAccessible.setSelectFields(Arrays.asList("id", "type", "action", "actor", "info", "content", "entry", "bytes"));
        return tableAccessible;
    }

    @Override
    public boolean isBeanConfigured() {
        return this.reconfigured;
    }

    @Override
    public void saveAudit(String action, Object object) {
        if (this.tenable.isAudit()) {
            String auditId;
            if (object == null) {
                return;
            }
            BeanUtil.checkBeanConfigure(this);
            AuditInfo auditInfo = AuditInfo.context();
            if (Boolean.TRUE.equals(auditInfo.getSkip())) {
                log.debug("Skip audit {}", (Object)auditInfo);
                return;
            }
            String string = auditId = auditInfo.getId() != null ? auditInfo.getId() : "";
            if (auditId.isEmpty()) {
                SessionFactoryImpl requestSessionFactory = (SessionFactoryImpl)RequestContext.currentContext().getAttribute(EntityIntegrator.SESSION_FACTORY);
                String string2 = auditId = requestSessionFactory != null ? requestSessionFactory.getProperties().getOrDefault("hibernate.audit_identifier", "") : "";
                if (auditId.isEmpty()) {
                    return;
                }
            }
            String fAuditId = auditId;
            this.taskHandler.execute(() -> this.storeAudit(fAuditId, object, auditInfo, action));
        }
    }

    private void storeAudit(String auditId, Object object, AuditInfo auditInfo, String action) {
        AuditHelper.TrxManagerAccessible trxManagerAccessible = this.trxManagerAccessibles.get(auditId);
        if (trxManagerAccessible == null) {
            log.warn("TrxManagerAccessible is not found, for audit id: {}", (Object)auditId);
            return;
        }
        AuditHelper.TableAccessible tableAccessible = trxManagerAccessible.getTableAccessibles().getOrDefault(Void.class, null);
        SessionImplementor session = null;
        try {
            String id = OdtIdGenerator.createId("AUD");
            session = trxManagerAccessible.getAuditIntegrator().getSessionFactory().openSession();
            session.beginTransaction();
            NativeQuery query = session.createNativeQuery("insert into " + tableAccessible.getTable().getQualifiedTableName().render() + " (id, type, action, actor, info, content, bytes, entry) values (?,?,?,?,?,?,?,?)").setParameter(1, (Object)id).setParameter(2, (Object)(auditInfo.getType() != null ? auditInfo.getType() : object.getClass().getName())).setParameter(3, (Object)(action != null ? action : "")).setParameter(4, (Object)auditInfo.getActor()).setParameter(5, (Object)auditInfo.getInfo());
            if (object instanceof byte[]) {
                query.setParameter(6, null).setParameter(7, object);
            } else {
                String content = this.dataMapper.writeAsString(object, 1);
                query.setParameter(6, (Object)content).setParameter(7, null);
            }
            Long now = TimeUtil.currentEpochMillis();
            query.setParameter(8, (Object)now);
            query.executeUpdate();
            EntityHelper.commit((Session)session);
        }
        catch (Exception e) {
            try {
                EntityHelper.rollback(session);
                throw BeanUtil.exception(e);
            }
            catch (Throwable throwable) {
                EntityHelper.close(session);
                throw throwable;
            }
        }
        EntityHelper.close((Session)session);
    }

    @Override
    public AuditRequest getAuditRequest(byte[] data) throws CommonException {
        return AuditHelper.getAuditRequest(data);
    }

    @Override
    public Page<JsonNode> getAuditList(AuditRequest auditRequest) {
        Page<Object> page = Page.empty();
        if (auditRequest != null) {
            SessionImplementor session;
            String orderBy;
            EntityHelper.Where where;
            boolean isAnonymous;
            AuditHelper.TableAccessible tableAccessible;
            block20: {
                SessionFactoryImplementor sessionFactory;
                String auditId;
                String manager = auditRequest.getManager();
                TrxManagerInfo trxManagerInfo = this.entityTrxManager.getTrxManagerInfo(manager);
                if (trxManagerInfo == null) {
                    trxManagerInfo = this.entityTrxManager.getDefaultTrxManagerInfo();
                }
                if ((auditId = (sessionFactory = trxManagerInfo.getIntegrator().getSessionFactory()).getProperties().getOrDefault("hibernate.audit_identifier", "")).isEmpty()) {
                    return Page.empty();
                }
                AuditHelper.TrxManagerAccessible trxManagerAccessible = this.trxManagerAccessibles.get(auditId);
                Assert.notNull((Object)trxManagerAccessible, (String)("trxManagerAccessible is not found, for auditId: " + auditId));
                tableAccessible = trxManagerAccessible.getTableAccessibles().get(auditRequest.getType());
                isAnonymous = false;
                if (tableAccessible == null) {
                    tableAccessible = trxManagerAccessible.getTableAccessibles().get(Void.class);
                    isAnonymous = true;
                }
                page = Page.of(1);
                Page<?> inPage = auditRequest.getPage();
                if (inPage != null) {
                    if (inPage.getIndex() != null && inPage.getIndex() > 0) {
                        page.setIndex(inPage.getIndex());
                    }
                    if (inPage.getSize() != null && inPage.getSize() > 0) {
                        page.setSize(inPage.getSize());
                    }
                    if (inPage.getCount() != null) {
                        page.setCount(inPage.getCount());
                    }
                }
                where = AuditHelper.where(tableAccessible, null, auditRequest, isAnonymous);
                orderBy = AuditHelper.orderBy(tableAccessible, auditRequest);
                session = null;
                session = trxManagerAccessible.getAuditIntegrator().getSessionFactory().openSession();
                if (!Boolean.TRUE.equals(page.getCount())) break block20;
                NativeQuery query = session.createNativeQuery("select count(1) from " + tableAccessible.getTable().getQualifiedTableName() + " " + where.getQuery());
                for (int i = 0; i < where.getParameters().size(); ++i) {
                    query.setParameter(i + 1, where.getParameters().get(i));
                }
                Long records = Long.valueOf("" + query.getSingleResult());
                page.setRecords(records);
                if (records != 0L) break block20;
                Page<Object> page2 = page;
                EntityHelper.close((Session)session);
                return page2;
            }
            try {
                boolean isIgnoreBytes = !Boolean.FALSE.equals(auditRequest.getIgnoreBytes());
                String sql = tableAccessible.getSelectSql();
                if (isAnonymous && isIgnoreBytes) {
                    sql = sql.substring(0, sql.lastIndexOf(","));
                }
                NativeQuery query = session.createNativeQuery("select " + sql + " from " + tableAccessible.getTable().getQualifiedTableName() + " " + where.getQuery() + " " + orderBy);
                for (int i = 0; i < where.getParameters().size(); ++i) {
                    query.setParameter(i + 1, where.getParameters().get(i));
                }
                query.setFirstResult((page.getIndex() - 1) * page.getSize());
                query.setMaxResults(page.getSize().intValue());
                ArrayList<ObjectNode> data = new ArrayList<ObjectNode>();
                int size = tableAccessible.getSelectFields().size();
                if (isAnonymous && isIgnoreBytes) {
                    --size;
                }
                List items = query.getResultList();
                while (!items.isEmpty()) {
                    Object[] item = (Object[])items.remove(0);
                    ArrayNode array = this.dataMapper.convert((Object)item, ArrayNode.class);
                    ObjectNode node = this.dataMapper.createObjectNode();
                    for (int i = 0; i < size; ++i) {
                        String fieldName = tableAccessible.getSelectFields().get(i);
                        JsonNode row = array.get(i);
                        if (isIgnoreBytes && row.isBinary()) continue;
                        if (row.isNull()) {
                            node.putNull(fieldName);
                            continue;
                        }
                        node.put(fieldName, row.asText());
                    }
                    data.add(node);
                }
                page.setData(data);
            }
            catch (Exception e) {
                try {
                    throw BeanUtil.exception(e);
                }
                catch (Throwable throwable) {
                    EntityHelper.close(session);
                    throw throwable;
                }
            }
            EntityHelper.close((Session)session);
        }
        return page;
    }
}

