/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.cache.CacheGroupHandler;
import net.ideahut.springboot.cache.CacheGroupProperties;
import net.ideahut.springboot.cache.CacheGroupVariable;
import net.ideahut.springboot.cache.MemoryCacheHandler;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.task.TaskHandler;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class MemoryCacheGroupHandler
implements CacheGroupHandler,
InitializingBean {
    private Map<String, CacheGroupVariable> mapGroupVariables;
    private boolean initialized = false;
    private TaskHandler taskHandler;
    private DataMapper dataMapper;
    private List<CacheGroupProperties> groups;

    public MemoryCacheGroupHandler setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
        return this;
    }

    public MemoryCacheGroupHandler setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public MemoryCacheGroupHandler setGroups(List<CacheGroupProperties> groups) {
        this.groups = groups != null ? new ArrayList<CacheGroupProperties>(groups) : null;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.groups == null) {
            this.groups = new ArrayList<CacheGroupProperties>();
        }
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        this.mapGroupVariables = new HashMap<String, CacheGroupVariable>();
        for (CacheGroupProperties group : this.groups) {
            String name = group.getName() != null ? group.getName().trim() : "";
            Assert.hasLength((String)name, (String)"Cache group name is required");
            if (this.mapGroupVariables.containsKey(name)) {
                throw new CommonException("Duplicate cache group name: " + name);
            }
            MemoryCacheHandler handler = new MemoryCacheHandler();
            handler.setDataMapper(this.dataMapper);
            handler.setLimit(group.getLimit() != null && group.getLimit() > 0 ? group.getLimit() : 0);
            handler.setNullable(group.getNullable() != null ? group.getNullable() : Boolean.FALSE);
            handler.setTaskHandler(this.taskHandler);
            handler.afterPropertiesSet();
            CacheGroupVariable groupVariable = new CacheGroupVariable();
            groupVariable.setHandler(handler);
            groupVariable.setGroup(group);
            this.mapGroupVariables.put(name, groupVariable);
        }
        this.initialized = true;
    }

    @Override
    public <T> T get(Class<T> type, String group, String key, Callable<T> callable) {
        CacheGroupVariable groupVariable = this.getGroupVariable(group);
        return groupVariable.getHandler().get(type, key, callable);
    }

    @Override
    public <T> T get(Class<T> type, String group, String key) {
        return this.get(type, group, key, null);
    }

    @Override
    public <T> List<T> multiList(Class<T> type, String group, Collection<String> keys) {
        CacheGroupVariable groupVariable = this.getGroupVariable(group);
        return groupVariable.getHandler().multiList(type, keys);
    }

    @Override
    public <T> Map<String, T> multiMap(Class<T> type, String group, Collection<String> keys) {
        CacheGroupVariable groupVariable = this.getGroupVariable(group);
        return groupVariable.getHandler().multiMap(type, keys);
    }

    @Override
    public <T> T put(Class<T> type, String group, String key, T value) {
        CacheGroupVariable groupVariable = this.getGroupVariable(group);
        T result = groupVariable.getHandler().put(type, key, value);
        groupVariable.getHandler().expire(key, groupVariable.getGroup().getExpiry());
        return result;
    }

    @Override
    public void expire(String group, String key, Integer expiry) {
        CacheGroupVariable groupVariable = this.getGroupVariable(group);
        groupVariable.getHandler().expire(key, expiry);
    }

    @Override
    public void delete(String group, String key) {
        CacheGroupVariable groupVariable = this.getGroupVariable(group);
        groupVariable.getHandler().delete(key);
    }

    @Override
    public void multiDel(String group, Collection<String> keys) {
        CacheGroupVariable groupVariable = this.getGroupVariable(group);
        groupVariable.getHandler().multiDel(keys);
    }

    @Override
    public Long size(String group) {
        CacheGroupVariable groupVariable = this.getGroupVariable(group);
        return groupVariable.getHandler().size();
    }

    @Override
    public void clear(String group) {
        CacheGroupVariable groupVariable = this.getGroupVariable(group);
        groupVariable.getHandler().clear();
    }

    @Override
    public List<String> keys(String group) {
        CacheGroupVariable groupVariable = this.getGroupVariable(group);
        return groupVariable.getHandler().keys();
    }

    private CacheGroupVariable getGroupVariable(String group) {
        Assert.isTrue((boolean)this.initialized, (String)(MemoryCacheGroupHandler.class.getName() + " not initialized; call afterPropertiesSet() before using it"));
        CacheGroupVariable groupVariable = this.mapGroupVariables.get(group);
        Assert.notNull((Object)groupVariable, (String)("Cache group is not registered, for: " + group));
        return groupVariable;
    }
}

