/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.cache.CacheHandler;
import net.ideahut.springboot.cache.MemoryCacheStore;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.util.BeanUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class MemoryCacheHandler
implements CacheHandler,
InitializingBean {
    private final List<String> keys = Collections.synchronizedList(new ArrayList());
    private final Map<String, MemoryCacheStore> stores = Collections.synchronizedMap(new HashMap());
    private boolean initialized = false;
    private Boolean nullable;
    private Integer limit;
    private DataMapper dataMapper;
    private TaskHandler taskHandler;

    public MemoryCacheHandler setNullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public MemoryCacheHandler setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public MemoryCacheHandler setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public MemoryCacheHandler setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        if (this.nullable == null) {
            this.nullable = Boolean.FALSE;
        }
        if (this.limit == null || this.limit < 0) {
            this.limit = 0;
        }
        this.initialized = true;
    }

    @Override
    public <T> T get(Class<T> type, String key, Callable<T> callable) {
        this.initialized();
        MemoryCacheStore store = this.stores.get(key);
        if (store != null) {
            Object value = store.getValue();
            return (T)(value != null ? this.dataMapper.copy(value, type) : value);
        }
        if (callable != null) {
            try {
                T t = callable.call();
                return this.put(type, key, t);
            }
            catch (Exception e) {
                throw BeanUtil.exception(e);
            }
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> type, String key) {
        return this.get(type, key, null);
    }

    @Override
    public <T> List<T> multiList(Class<T> type, Collection<String> keys) {
        this.initialized();
        ArrayList<T> result = new ArrayList<T>();
        if (keys != null) {
            for (String key : keys) {
                MemoryCacheStore store = this.stores.get(key);
                if (store != null) {
                    Object value = store.getValue();
                    if (value != null) {
                        T tval = this.dataMapper.copy(value, type);
                        result.add(tval);
                        continue;
                    }
                    result.add(null);
                    continue;
                }
                result.add(null);
            }
        }
        return result;
    }

    @Override
    public <T> Map<String, T> multiMap(Class<T> type, Collection<String> keys) {
        this.initialized();
        HashMap<String, T> result = new HashMap<String, T>();
        if (keys != null) {
            for (String key : keys) {
                MemoryCacheStore store = this.stores.get(key);
                if (store != null) {
                    Object value = store.getValue();
                    if (value != null) {
                        T tval = this.dataMapper.copy(value, type);
                        result.put(key, tval);
                        continue;
                    }
                    result.put(key, null);
                    continue;
                }
                result.put(key, null);
            }
        }
        return result;
    }

    @Override
    public <T> T put(Class<T> type, String key, T value) {
        this.initialized();
        if (!Boolean.TRUE.equals(this.nullable) && value == null) {
            return value;
        }
        this.keys.remove(key);
        if (this.keys.add(key)) {
            T cvalue = value != null ? this.dataMapper.copy(value, type) : value;
            this.stores.put(key, new MemoryCacheStore<T>(cvalue, 0));
            this.runTask(this.limitKeys());
        }
        return value;
    }

    @Override
    public void expire(String key, Integer expiry) {
        this.initialized();
        MemoryCacheStore store = this.stores.get(key);
        if (store != null) {
            store.setExpiry(expiry);
        }
    }

    @Override
    public void delete(String key) {
        this.keys.remove(key);
        this.stores.remove(key);
    }

    @Override
    public void multiDel(Collection<String> keys) {
        if (keys != null) {
            for (String key : keys) {
                this.delete(key);
            }
        }
    }

    @Override
    public Long size() {
        if (this.limit == 0) {
            return -1L;
        }
        return this.keys.size();
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.stores.clear();
    }

    @Override
    public List<String> keys() {
        if (this.limit == 0) {
            return new ArrayList<String>();
        }
        return Collections.unmodifiableList(this.keys);
    }

    private Runnable limitKeys() {
        return () -> {
            if (this.limit == 0) {
                return;
            }
            while (this.keys.size() > this.limit) {
                String key = this.keys.remove(0);
                this.stores.remove(key);
            }
        };
    }

    private void runTask(Runnable task) {
        if (this.taskHandler != null) {
            this.taskHandler.execute(task);
        } else {
            task.run();
        }
    }

    private void initialized() {
        Assert.isTrue((boolean)this.initialized, (String)(MemoryCacheHandler.class.getName() + " not initialized; call afterPropertiesSet() before using it"));
    }
}

