/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.ideahut.springboot.cache.CacheHandler;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.util.BeanUtil;
import net.ideahut.springboot.util.StringUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;

public class RedisCacheHandler
implements CacheHandler,
InitializingBean {
    private static final byte[] NULL = new byte[]{0};
    private static final String KEYS = "##__KEYS__##__@";
    private boolean initialized = false;
    private String prefix;
    private Boolean nullable;
    private Integer limit;
    private RedisTemplate<String, byte[]> redisTemplate;
    private DataMapper dataMapper;
    private TaskHandler taskHandler;

    public RedisCacheHandler setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public RedisCacheHandler setNullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public RedisCacheHandler setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public RedisCacheHandler setRedisTemplate(RedisTemplate<String, byte[]> redisTemplate) {
        this.redisTemplate = redisTemplate;
        return this;
    }

    public RedisCacheHandler setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public RedisCacheHandler setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.redisTemplate, (String)"redisTemplate is required");
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        String string = this.prefix = this.prefix != null ? this.prefix.trim() : "";
        if (this.nullable == null) {
            this.nullable = Boolean.FALSE;
        }
        if (this.limit == null || this.limit < 0) {
            this.limit = 0;
        }
        this.initialized = true;
    }

    @Override
    public <T> T get(Class<T> type, String key, Callable<T> callable) {
        this.initialized();
        ValueOperations operations = this.redisTemplate.opsForValue();
        byte[] value = (byte[])operations.get((Object)this.unique(key));
        Object t = null;
        if (value != null) {
            t = value.length == 1 && value[0] == NULL[0] ? null : (byte[].class.isAssignableFrom(type) ? value : (Object)this.dataMapper.read(value, type));
        } else if (callable != null) {
            try {
                t = callable.call();
                return (T)this.put(type, key, t);
            }
            catch (Exception e) {
                throw BeanUtil.exception(e);
            }
        }
        return (T)t;
    }

    @Override
    public <T> T get(Class<T> type, String key) {
        return this.get(type, key, null);
    }

    @Override
    public <T> List<T> multiList(Class<T> type, Collection<String> keys) {
        this.initialized();
        ArrayList<Object> result = new ArrayList<Object>();
        if (keys == null) {
            return result;
        }
        ValueOperations operations = this.redisTemplate.opsForValue();
        ArrayList<String> lkeys = new ArrayList<String>();
        for (String key : keys) {
            lkeys.add(this.unique(key));
        }
        List values = operations.multiGet(lkeys);
        if (values != null) {
            while (!values.isEmpty()) {
                byte[] value = (byte[])values.remove(0);
                if (value != null) {
                    if (value.length == 1 && value[0] == NULL[0]) {
                        result.add(null);
                        continue;
                    }
                    if (byte[].class.isAssignableFrom(type)) {
                        result.add(value);
                        continue;
                    }
                    T tval = this.dataMapper.read(value, type);
                    result.add(tval);
                    continue;
                }
                result.add(null);
            }
        } else {
            for (int i = 0; i < lkeys.size(); ++i) {
                result.add(null);
            }
        }
        return result;
    }

    @Override
    public <T> Map<String, T> multiMap(Class<T> type, Collection<String> keys) {
        this.initialized();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (keys == null) {
            return result;
        }
        ValueOperations operations = this.redisTemplate.opsForValue();
        ArrayList<String> lkeys = new ArrayList<String>();
        for (String key : keys) {
            lkeys.add(this.unique(key));
        }
        List values = operations.multiGet(lkeys);
        if (values != null) {
            int i = 0;
            while (!values.isEmpty()) {
                byte[] value = (byte[])values.remove(0);
                if (value != null) {
                    if (value.length == 1 && value[0] == NULL[0]) {
                        result.put((String)lkeys.get(i), null);
                    } else if (byte[].class.isAssignableFrom(type)) {
                        result.put((String)lkeys.get(i), value);
                    } else {
                        T tval = this.dataMapper.read(value, type);
                        result.put((String)lkeys.get(i), tval);
                    }
                } else {
                    result.put((String)lkeys.get(i), null);
                }
                ++i;
            }
        } else {
            for (int i = 0; i < lkeys.size(); ++i) {
                result.put((String)lkeys.get(i), null);
            }
        }
        return result;
    }

    @Override
    public <T> T put(Class<T> type, String key, T value) {
        this.initialized();
        if (!Boolean.TRUE.equals(this.nullable) && value == null) {
            return value;
        }
        ValueOperations operations = this.redisTemplate.opsForValue();
        byte[] bytes = value != null ? this.dataMapper.writeAsBytes(value, 1) : NULL;
        operations.set((Object)this.unique(key), (Object)bytes);
        this.runTask(this.addKey(key));
        return value;
    }

    @Override
    public void expire(String key, Integer expiry) {
        this.initialized();
        if (expiry != null && expiry > 0) {
            this.redisTemplate.expire((Object)this.unique(key), (long)expiry.intValue(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void delete(String key) {
        this.initialized();
        this.redisTemplate.delete((Object)this.unique(key));
        this.runTask(this.delKey(Arrays.asList(key)));
    }

    @Override
    public void multiDel(Collection<String> keys) {
        this.initialized();
        if (keys == null) {
            return;
        }
        HashSet<String> lkeys = new HashSet<String>();
        for (String key : keys) {
            lkeys.add(this.unique(key));
        }
        if (!lkeys.isEmpty()) {
            this.redisTemplate.delete(lkeys);
            this.runTask(this.delKey(keys));
        }
    }

    @Override
    public Long size() {
        if (!this.prefix.isEmpty() && this.limit != 0) {
            String gkey = KEYS + this.prefix;
            ListOperations operations = this.redisTemplate.opsForList();
            Long size = operations.size((Object)gkey);
            if (size != null) {
                return size;
            }
            return 0L;
        }
        return -1L;
    }

    @Override
    public void clear() {
        this.runTask(this.clearKeys());
    }

    @Override
    public List<String> keys() {
        this.initialized();
        ArrayList<String> skeys = new ArrayList<String>();
        if (!this.prefix.isEmpty() && this.limit != 0) {
            List bkeys;
            String gkey = KEYS + this.prefix;
            ListOperations operations = this.redisTemplate.opsForList();
            Long size = operations.size((Object)gkey);
            if (size != null && (bkeys = operations.range((Object)gkey, 0L, size.longValue())) != null) {
                while (!bkeys.isEmpty()) {
                    skeys.add(new String((byte[])bkeys.remove(0), StringUtil.CHARSET));
                }
            }
        }
        return skeys;
    }

    private String unique(String key) {
        return this.prefix + key;
    }

    private Runnable addKey(String key) {
        return () -> this.addKey0(key);
    }

    private synchronized void addKey0(String key) {
        if (!this.prefix.isEmpty() && this.limit != 0) {
            String gkey = KEYS + this.prefix;
            byte[] vkey = key.getBytes(StringUtil.CHARSET);
            ListOperations operations = this.redisTemplate.opsForList();
            operations.remove((Object)gkey, 1L, (Object)vkey);
            operations.rightPush((Object)gkey, (Object)vkey);
            long size = operations.size((Object)gkey);
            long diff = size - (long)this.limit.intValue();
            if (diff > 0L) {
                HashSet<String> vkeys = new HashSet<String>();
                int i = 0;
                while ((long)i < diff) {
                    byte[] bkey = (byte[])operations.leftPop((Object)gkey);
                    vkeys.add(this.unique(new String(bkey, StringUtil.CHARSET)));
                    ++i;
                }
                this.redisTemplate.delete(vkeys);
            }
        }
    }

    private Runnable delKey(Collection<String> codes) {
        return () -> {
            if (!this.prefix.isEmpty() && this.limit != 0 && codes != null && codes.isEmpty()) {
                String gkey = KEYS + this.prefix;
                ListOperations operations = this.redisTemplate.opsForList();
                for (String code : codes) {
                    operations.remove((Object)gkey, 1L, (Object)code.getBytes(StringUtil.CHARSET));
                }
            }
        };
    }

    private Runnable clearKeys() {
        return this::clearKeys0;
    }

    private void clearKeys0() {
        String gkey = KEYS + this.prefix;
        ListOperations operations = this.redisTemplate.opsForList();
        Long size = operations.size((Object)gkey);
        HashSet<String> vkeys = new HashSet<String>();
        for (long i = 0L; i < size; ++i) {
            byte[] key = (byte[])operations.leftPop((Object)gkey);
            vkeys.add(this.unique(new String(key, StringUtil.CHARSET)));
        }
        this.redisTemplate.delete(vkeys);
    }

    private void runTask(Runnable task) {
        if (this.limit == 0) {
            return;
        }
        if (task == null) {
            return;
        }
        if (this.taskHandler != null) {
            this.taskHandler.execute(task);
        } else {
            task.run();
        }
    }

    private void initialized() {
        if (!this.initialized) {
            throw BeanUtil.exception(RedisCacheHandler.class.getName() + " not initialized; call afterPropertiesSet() before using it");
        }
    }
}

