/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.context;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class RequestContext {
    private static final ThreadLocal<RequestContext> holder = new InheritableThreadLocal<RequestContext>();
    private static final ThreadLocal<Long> start = new InheritableThreadLocal<Long>();
    private final Long id;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private HttpServletRequest request;
    private HttpServletResponse response;

    public static RequestContext currentContext() {
        RequestContext context = holder.get();
        if (context == null) {
            context = new RequestContext();
            holder.set(context);
        }
        return context;
    }

    public static void start() {
        start.set(System.currentTimeMillis());
    }

    public static Long time() {
        Long begin = start.get();
        if (begin != null) {
            return System.currentTimeMillis() - begin;
        }
        return null;
    }

    public static void destroy() {
        holder.remove();
        start.remove();
    }

    private RequestContext() {
        this.id = System.nanoTime();
    }

    public Long getId() {
        return this.id;
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public <T> T getAttribute(String name, T defaultValue) {
        Object t = this.attributes.get(name);
        return (T)(t != null ? t : defaultValue);
    }

    public <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public <T> RequestContext setAttribute(String name, T value) {
        this.attributes.put(name, value);
        return this;
    }

    public RequestContext removeAttribute(String name) {
        this.attributes.remove(name);
        return this;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public RequestContext setRequest(HttpServletRequest request) {
        this.request = request;
        return this;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public RequestContext setResponse(HttpServletResponse response) {
        this.response = response;
        return this;
    }
}

