/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.util.Collection;
import net.ideahut.springboot.converter.Helper;
import net.ideahut.springboot.util.BeanUtil;

public abstract class Converter {
    private final Class<?> type;

    protected Converter() {
        this.type = null;
    }

    protected Converter(Class<?> type) {
        this.type = type;
    }

    protected String getValue(Collection<String> args, boolean isTrim) {
        String value = args != null && !args.isEmpty() ? args.iterator().next() : "";
        return isTrim ? value.trim() : value;
    }

    protected Class<?> getType() {
        return this.type;
    }

    public abstract Object convert(Collection<String> var1);

    public abstract boolean isSupported(Class<?> var1);

    public static Converter of(Class<?> type) {
        return Helper.getConverter(type);
    }

    protected static void isEqual(Class<?> base, Class<?> type) {
        boolean equal;
        boolean bl = equal = base != null && type != null && base.isAssignableFrom(type);
        if (!equal) {
            throw BeanUtil.exception("Invalid type");
        }
    }
}

