/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.util.BeanUtil;

public class DateConverter
extends Converter {
    protected DateConverter() {
    }

    public DateConverter(Class<?> type) {
        super(type);
        DateConverter.isEqual(Date.class, type);
    }

    @Override
    public Object convert(Collection<String> args) {
        String input = super.getValue(args, true);
        if (input.isEmpty()) {
            return null;
        }
        String[] sgra = args.toArray(new String[0]);
        SimpleDateFormat dateFormat = new SimpleDateFormat(sgra.length > 1 ? sgra[1] : "yyyy-MM-dd HH:mm:ss.SSS");
        try {
            return dateFormat.parse(input);
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    @Override
    public boolean isSupported(Class<?> type) {
        return Date.class.isAssignableFrom(type);
    }
}

