/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.util.ArrayList;
import java.util.List;
import net.ideahut.springboot.converter.BooleanConverter;
import net.ideahut.springboot.converter.CharacterConverter;
import net.ideahut.springboot.converter.CollectionConverter;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.converter.DateConverter;
import net.ideahut.springboot.converter.DoubleConverter;
import net.ideahut.springboot.converter.EntityConverter;
import net.ideahut.springboot.converter.FloatConverter;
import net.ideahut.springboot.converter.IntegerConverter;
import net.ideahut.springboot.converter.LocalDateConverter;
import net.ideahut.springboot.converter.LocalDateTimeConverter;
import net.ideahut.springboot.converter.LocalTimeConverter;
import net.ideahut.springboot.converter.LongConverter;
import net.ideahut.springboot.converter.NumberConverter;
import net.ideahut.springboot.converter.PrimitiveBooleanConverter;
import net.ideahut.springboot.converter.PrimitiveCharacterConverter;
import net.ideahut.springboot.converter.StringConverter;
import net.ideahut.springboot.util.BeanUtil;

final class Helper {
    private static final List<Converter> converters = new ArrayList<Converter>();

    private Helper() {
    }

    public static Converter getConverter(Class<?> type) {
        try {
            for (Converter converter : converters) {
                if (!converter.isSupported(type)) continue;
                return (Converter)converter.getClass().getConstructor(Class.class).newInstance(type);
            }
        }
        catch (Exception e) {
            BeanUtil.nothing();
        }
        return null;
    }

    static {
        converters.add(new BooleanConverter());
        converters.add(new CharacterConverter());
        converters.add(new CollectionConverter());
        converters.add(new DateConverter());
        converters.add(new DoubleConverter());
        converters.add(new EntityConverter());
        converters.add(new FloatConverter());
        converters.add(new IntegerConverter());
        converters.add(new LocalDateConverter());
        converters.add(new LocalDateTimeConverter());
        converters.add(new LocalTimeConverter());
        converters.add(new LongConverter());
        converters.add(new NumberConverter());
        converters.add(new PrimitiveBooleanConverter());
        converters.add(new PrimitiveCharacterConverter());
        converters.add(new StringConverter());
    }
}

