/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import net.ideahut.springboot.converter.Converter;

public class LocalDateTimeConverter
extends Converter {
    protected LocalDateTimeConverter() {
    }

    public LocalDateTimeConverter(Class<?> type) {
        super(type);
        LocalDateTimeConverter.isEqual(LocalDateTime.class, type);
    }

    @Override
    public Object convert(Collection<String> args) {
        String input = super.getValue(args, true);
        if (input.isEmpty()) {
            return null;
        }
        String[] sgra = args.toArray(new String[0]);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(sgra.length > 1 ? sgra[1] : "yyyy-MM-dd HH:mm:ss.SSS");
        return LocalDateTime.parse(input, formatter);
    }

    @Override
    public boolean isSupported(Class<?> type) {
        return LocalDateTime.class.isAssignableFrom(type);
    }
}

