/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import net.ideahut.springboot.converter.Converter;

public class LocalTimeConverter
extends Converter {
    protected LocalTimeConverter() {
    }

    public LocalTimeConverter(Class<?> type) {
        super(type);
        LocalTimeConverter.isEqual(LocalTime.class, type);
    }

    @Override
    public Object convert(Collection<String> args) {
        String input = super.getValue(args, true);
        if (input.isEmpty()) {
            return null;
        }
        String[] sgra = args.toArray(new String[0]);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(sgra.length > 1 ? sgra[1] : "HH:mm:ss.SSS");
        return LocalTime.parse(input, formatter);
    }

    @Override
    public boolean isSupported(Class<?> type) {
        return LocalTime.class.isAssignableFrom(type);
    }
}

