/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.ideahut.springboot.crud.CrudField;
import net.ideahut.springboot.crud.CrudId;
import net.ideahut.springboot.entity.EntityInfo;

public class CrudEntity
implements Comparable<CrudEntity> {
    @JsonIgnore
    private final EntityInfo entityInfo;
    private final String crudName;
    private final CrudId id;
    private final List<CrudField> fields;

    public CrudEntity(EntityInfo entityInfo, String crudName, CrudId id, List<CrudField> fields) {
        this.entityInfo = entityInfo;
        this.crudName = crudName;
        this.id = id;
        this.fields = fields != null ? Collections.unmodifiableList(fields) : null;
    }

    @Override
    public int compareTo(CrudEntity o) {
        if (o != null && o.getCrudName() != null && this.crudName != null) {
            return this.crudName.compareToIgnoreCase(o.getCrudName());
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.crudName, this.entityInfo, this.fields, this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrudEntity other = (CrudEntity)obj;
        return Objects.equals(this.crudName, other.crudName) && Objects.equals(this.entityInfo, other.entityInfo) && Objects.equals(this.fields, other.fields) && Objects.equals(this.id, other.id);
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    public String getCrudName() {
        return this.crudName;
    }

    public CrudId getId() {
        return this.id;
    }

    public List<CrudField> getFields() {
        return this.fields;
    }
}

